package org.hibernate.search.engine.logging.impl;

import java.util.Locale;
import org.hibernate.search.util.common.reporting.EventContext;
import java.io.Serializable;
import org.hibernate.search.engine.mapper.model.spi.MappingElement;
import java.util.Set;
import org.hibernate.search.util.common.SearchException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;

/**
 * Warning this class consists of generated code.
 */
public class MappingLog_$logger implements MappingLog, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = MappingLog_$logger.class.getName();
    public MappingLog_$logger(final Logger log) {
        this.log = log;
    }
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String relativeFieldNameCannotBeNullOrEmpty$str() {
        return "HSEARCH000514: Invalid index field name '%1$s': field names cannot be null or empty.";
    }
    @Override
    public final SearchException relativeFieldNameCannotBeNullOrEmpty(final String relativeFieldName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), relativeFieldNameCannotBeNullOrEmpty$str(), relativeFieldName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String relativeFieldNameCannotContainDot$str() {
        return "HSEARCH000515: Invalid index field name '%1$s': field names cannot contain a dot ('.'). Remove the dot from your field name, or if you are declaring the field in a bridge and want a tree of fields, declare an object field using the objectField() method.";
    }
    @Override
    public final SearchException relativeFieldNameCannotContainDot(final String relativeFieldName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), relativeFieldNameCannotContainDot$str(), relativeFieldName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String indexedEmbeddedCyclicRecursion$str() {
        return "HSEARCH000546: Cyclic recursion starting from '%1$s' on %2$s. Index field path starting from that location and ending with a cycle: '%3$s'. A type cannot declare an unrestricted @IndexedEmbedded to itself, even indirectly. To break the cycle, you should consider adding filters to your @IndexedEmbedded: includePaths, includeDepth, excludePaths, ...";
    }
    @Override
    public final SearchException indexedEmbeddedCyclicRecursion(final MappingElement indexedEmbedded, final EventContext indexedEmbeddedLocation, final String cyclicRecursionPath) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), indexedEmbeddedCyclicRecursion$str(), indexedEmbedded, new org.hibernate.search.util.common.logging.impl.EventContextNoPrefixFormatter(indexedEmbeddedLocation), cyclicRecursionPath));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String fieldTemplateNameCannotBeNullOrEmpty$str() {
        return "HSEARCH000570: Invalid index field template name '%1$s': field template names cannot be null or empty.";
    }
    @Override
    public final SearchException fieldTemplateNameCannotBeNullOrEmpty(final String templateName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), fieldTemplateNameCannotBeNullOrEmpty$str(), templateName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String fieldTemplateNameCannotContainDot$str() {
        return "HSEARCH000571: Invalid index field template name '%1$s': field template names cannot contain a dot ('.').";
    }
    @Override
    public final SearchException fieldTemplateNameCannotContainDot(final String relativeFieldName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), fieldTemplateNameCannotContainDot$str(), relativeFieldName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String twoTypesTargetSameIndex$str() {
        return "HSEARCH000588: Multiple entity types mapped to index '%1$s': '%2$s', '%3$s'. Each indexed type must be mapped to its own, dedicated index.";
    }
    @Override
    public final SearchException twoTypesTargetSameIndex(final String indexName, final String mappedTypeName, final String anotherMappedTypeName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), twoTypesTargetSameIndex$str(), indexName, mappedTypeName, anotherMappedTypeName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String relativeNamedPredicateNameCannotBeNullOrEmpty$str() {
        return "HSEARCH000593: Named predicate name '%1$s' is invalid: field names cannot be null or empty.";
    }
    @Override
    public final SearchException relativeNamedPredicateNameCannotBeNullOrEmpty(final String relativeNamedPredicateName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), relativeNamedPredicateNameCannotBeNullOrEmpty$str(), relativeNamedPredicateName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String relativeNamedPredicateNameCannotContainDot$str() {
        return "HSEARCH000594: Named predicate name '%1$s' is invalid: field names cannot contain a dot ('.'). Remove the dot from your named predicate name.";
    }
    @Override
    public final SearchException relativeNamedPredicateNameCannotContainDot(final String relativeNamedPredicateName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), relativeNamedPredicateNameCannotContainDot$str(), relativeNamedPredicateName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidIndexNodeTypeNotComposite$str() {
        return "HSEARCH000598: Invalid type: %1$s is not composite.";
    }
    @Override
    public final SearchException invalidIndexNodeTypeNotComposite(final EventContext elementContext) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidIndexNodeTypeNotComposite$str(), new org.hibernate.search.util.common.logging.impl.EventContextNoPrefixFormatter(elementContext)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidIndexNodeTypeNotObjectField$str() {
        return "HSEARCH000599: Invalid type: %1$s is not an object field.";
    }
    @Override
    public final SearchException invalidIndexNodeTypeNotObjectField(final EventContext elementContext) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidIndexNodeTypeNotObjectField$str(), new org.hibernate.search.util.common.logging.impl.EventContextNoPrefixFormatter(elementContext)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidIndexNodeTypeNotValueField$str() {
        return "HSEARCH000600: Invalid type: %1$s is not a value field.";
    }
    @Override
    public final SearchException invalidIndexNodeTypeNotValueField(final EventContext elementContext) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidIndexNodeTypeNotValueField$str(), new org.hibernate.search.util.common.logging.impl.EventContextNoPrefixFormatter(elementContext)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToResolveField$str() {
        return "HSEARCH000615: Unable to resolve field '%1$s': %2$s";
    }
    @Override
    public final SearchException unableToResolveField(final String absolutePath, final String causeMessage, final SearchException e, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToResolveField$str(), absolutePath, causeMessage), e, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotIncludeAndExcludePathsWithinSameFilter$str() {
        return "HSEARCH000619: 'includePaths' and 'excludePaths' cannot be used together in the same filter. Use either `includePaths` or `excludePaths` leaving the other one empty. Included paths are: '%1$s', excluded paths are: '%2$s'.";
    }
    @Override
    public final SearchException cannotIncludeAndExcludePathsWithinSameFilter(final Set<String> includePaths, final Set<String> excludePaths) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotIncludeAndExcludePathsWithinSameFilter$str(), includePaths, excludePaths));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
