package org.hibernate.search.engine.logging.impl;

import java.util.Locale;
import org.hibernate.search.engine.spatial.GeoPoint;
import java.io.Serializable;
import org.hibernate.search.util.common.SearchException;
import java.lang.Class;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;
import java.time.format.DateTimeFormatter;
import java.lang.Exception;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
public class FormattingLog_$logger implements FormattingLog, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = FormattingLog_$logger.class.getName();
    public FormattingLog_$logger(final Logger log) {
        this.log = log;
    }
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String invalidPropertyValue$str() {
        return "HSEARCH000502: Invalid value: expected either an instance of '%1$s' or a String that can be parsed into that type. %2$s";
    }
    @Override
    public final SearchException invalidPropertyValue(final Class<?> expectedType, final String errorMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidPropertyValue$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(expectedType), errorMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String invalidBooleanPropertyValue$str() {
        return "HSEARCH000503: Invalid Boolean value: expected either a Boolean, the String 'true' or the String 'false'. %1$s";
    }
    @Override
    public final SearchException invalidBooleanPropertyValue(final String nestedErrorMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidBooleanPropertyValue$str(), nestedErrorMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidIntegerPropertyValue$str() {
        return "HSEARCH000504: Invalid Integer value: expected either a Number or a String that can be parsed into an Integer. %1$s";
    }
    @Override
    public final SearchException invalidIntegerPropertyValue(final String nestedErrorMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidIntegerPropertyValue$str(), nestedErrorMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidLongPropertyValue$str() {
        return "HSEARCH000505: Invalid Long value: expected either a Number or a String that can be parsed into a Long. %1$s";
    }
    @Override
    public final SearchException invalidLongPropertyValue(final String nestedErrorMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidLongPropertyValue$str(), nestedErrorMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidMultiPropertyValue$str() {
        return "HSEARCH000506: Invalid multi value: expected either a single value of the correct type, a Collection, or a String, and interpreting as a single value failed with the following exception. %1$s";
    }
    @Override
    public final SearchException invalidMultiPropertyValue(final String nestedErrorMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidMultiPropertyValue$str(), nestedErrorMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidGeoPolygonFirstPointNotIdenticalToLastPoint$str() {
        return "HSEARCH000516: Invalid polygon: the first point '%1$s' should be identical to the last point '%2$s' to properly close the polygon.";
    }
    @Override
    public final IllegalArgumentException invalidGeoPolygonFirstPointNotIdenticalToLastPoint(final GeoPoint firstPoint, final GeoPoint lastPoint) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidGeoPolygonFirstPointNotIdenticalToLastPoint$str(), firstPoint, lastPoint));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidBeanReferencePropertyValue$str() {
        return "HSEARCH000547: Invalid BeanReference value: expected an instance of '%1$s', BeanReference, String or Class. %2$s";
    }
    @Override
    public final SearchException invalidBeanReferencePropertyValue(final Class<?> expectedType, final String nestedErrorMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidBeanReferencePropertyValue$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(expectedType), nestedErrorMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToParseTemporal$str() {
        return "HSEARCH000557: Invalid value for type '%1$s': '%2$s'. The expected format is '%3$s'.";
    }
    @Override
    public final SearchException unableToParseTemporal(final Class<? extends java.time.temporal.TemporalAccessor> type, final String value, final DateTimeFormatter formatter, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToParseTemporal$str(), new org.hibernate.search.util.common.logging.impl.SimpleNameClassFormatter(type), value, formatter), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidNumberPropertyValue$str() {
        return "HSEARCH000558: Invalid %1$s value: expected either a Number or a String that can be parsed into a %1$s. %2$s";
    }
    @Override
    public final SearchException invalidNumberPropertyValue(final Class<? extends Number> type, final String nestedErrorMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidNumberPropertyValue$str(), new org.hibernate.search.util.common.logging.impl.SimpleNameClassFormatter(type), nestedErrorMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidStringForType$str() {
        return "HSEARCH000559: Invalid string for type '%2$s': '%1$s'. %3$s";
    }
    @Override
    public final SearchException invalidStringForType(final String value, final Class<?> type, final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidStringForType$str(), value, new org.hibernate.search.util.common.logging.impl.ClassFormatter(type), causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidStringForEnum$str() {
        return "HSEARCH000560: Invalid value for enum '%2$s': '%1$s'.";
    }
    @Override
    public final SearchException invalidStringForEnum(final String value, final Class<? extends Enum<?>> enumType, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidStringForEnum$str(), value, new org.hibernate.search.util.common.logging.impl.ClassFormatter(enumType)), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToParseGeoPoint$str() {
        return "HSEARCH000564: Invalid geo-point value: '%1$s'. The expected format is '<latitude as double>, <longitude as double>'.";
    }
    @Override
    public final SearchException unableToParseGeoPoint(final String value) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToParseGeoPoint$str(), value));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
