package org.hibernate.search.engine.logging.impl;

import java.util.Locale;
import org.hibernate.search.engine.environment.bean.spi.BeanNotFoundException;
import java.io.Serializable;
import org.hibernate.search.engine.environment.classpath.spi.ClassLoadingException;
import org.hibernate.search.util.common.SearchException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.hibernate.search.util.common.reporting.spi.EventContextProvider;
import java.lang.RuntimeException;
import java.lang.Runnable;
import java.util.Collection;
import java.lang.Throwable;
import java.lang.Class;
import java.util.List;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class EngineMiscLog_$logger implements EngineMiscLog, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = EngineMiscLog_$logger.class.getName();
    public EngineMiscLog_$logger(final Logger log) {
        this.log = log;
    }
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String noPublicNoArgConstructor$str() {
        return "HSEARCH000242: Invalid type '%1$s': missing constructor. The type must expose a public, no-arguments constructor.";
    }
    @Override
    public final SearchException noPublicNoArgConstructor(final Class<?> clazz) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), noPublicNoArgConstructor$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(clazz)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String collectedFailureLimitReached$str() {
        return "HSEARCH000519: Hibernate Search encountered %3$s failures during %1$s. Only the first %2$s failures are displayed here. See the TRACE logs for extra failures.";
    }
    @Override
    public final String collectedFailureLimitReached(final String process, final int failureLimit, final int failureCount) {
        return String.format(getLoggingLocale(), collectedFailureLimitReached$str(), process, failureLimit, failureCount);
    }
    protected String collectedFailures$str() {
        return "HSEARCH000520: Hibernate Search encountered failures during %1$s. Failures:\n%2$s";
    }
    @Override
    public final SearchException collectedFailures(final String process, final String renderedFailures, final Collection<Throwable> failures) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), collectedFailures$str(), process, renderedFailures));
        _copyStackTraceMinusOne(result);
        failures.forEach($failuresVar -> result.addSuppressed($failuresVar));
        return result;
    }
    @Override
    public final void newCollectedFailure(final String process, final EventContextProvider contextProvider, final Throwable failure) {
        log.logf(FQCN, TRACE, failure, newCollectedFailure$str(), process, new org.hibernate.search.util.common.logging.impl.EventContextFormatter(contextProvider));
    }
    protected String newCollectedFailure$str() {
        return "HSEARCH000521: Hibernate Search encountered a failure during %1$s; continuing for now to list all problems, but the process will ultimately be aborted.\n%2$s\nFailure:";
    }
    @Override
    public final void exceptionWhileCollectingFailure(final String causeMessage, final Throwable cause) {
        log.logf(FQCN, WARN, cause, exceptionWhileCollectingFailure$str(), causeMessage);
    }
    protected String exceptionWhileCollectingFailure$str() {
        return "HSEARCH000522: Exception while collecting a failure -- this may indicate a bug or a missing test in Hibernate Search. Please report it: https://hibernate.org/community/ Nested exception: %1$s";
    }
    protected String cannotCallDslExtensionIfSupportedAfterOrElse$str() {
        return "HSEARCH000525: Invalid call of ifSupported(...) after orElse(...). Use a separate extension() context, or move the orElse(...) call last.";
    }
    @Override
    public final SearchException cannotCallDslExtensionIfSupportedAfterOrElse() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotCallDslExtensionIfSupportedAfterOrElse$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String dslExtensionNoMatch$str() {
        return "HSEARCH000526: None of the provided extensions can be applied to the current context.  Attempted extensions: %1$s. If you want to ignore this, use .extension().ifSupported(...).orElse(ignored -> { }).";
    }
    @Override
    public final SearchException dslExtensionNoMatch(final List<?> attemptedExtensions) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), dslExtensionNoMatch$str(), attemptedExtensions));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToLoadTheClass$str() {
        return "HSEARCH000530: Unable to load class '%1$s': %2$s";
    }
    @Override
    public final ClassLoadingException unableToLoadTheClass(final String className, final String causeMessage, final Throwable cause) {
        final ClassLoadingException result = new ClassLoadingException(String.format(getLoggingLocale(), unableToLoadTheClass$str(), className, causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToInstantiateClass$str() {
        return "HSEARCH000540: Unable to instantiate class '%1$s': %2$s";
    }
    @Override
    public final SearchException unableToInstantiateClass(final String className, final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToInstantiateClass$str(), className, causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String subtypeExpected$str() {
        return "HSEARCH000542: Invalid type '%1$s': this type cannot be assigned to type '%2$s'.";
    }
    @Override
    public final SearchException subtypeExpected(final Class<?> classToLoad, final Class<?> superType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), subtypeExpected$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(classToLoad), new org.hibernate.search.util.common.logging.impl.ClassFormatter(superType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String implementationRequired$str() {
        return "HSEARCH000543: Invalid type '%1$s': this type is an interface. An implementation class is required.";
    }
    @Override
    public final SearchException implementationRequired(final Class<?> classToLoad) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), implementationRequired$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(classToLoad)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noPublicMapArgConstructor$str() {
        return "HSEARCH000544: Invalid type '%1$s': missing constructor. The type must expose a public constructor with a single parameter of type Map.";
    }
    @Override
    public final SearchException noPublicMapArgConstructor(final Class<?> classToLoad) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), noPublicMapArgConstructor$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(classToLoad)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void failureInFailureHandler(final Throwable t) {
        log.logf(FQCN, ERROR, t, failureInFailureHandler$str());
    }
    protected String failureInFailureHandler$str() {
        return "HSEARCH000569: The background failure handler threw an exception while handling a previous failure. The failure may not have been reported.";
    }
    protected String multipleConfiguredBeanReferencesForType$str() {
        return "HSEARCH000576: Ambiguous bean reference to type '%1$s': multiple beans are explicitly defined for this type in Hibernate Search's internal registry. Explicitly defined beans: %2$s.";
    }
    @Override
    public final BeanNotFoundException multipleConfiguredBeanReferencesForType(final Class<?> exposedType, final List<? extends org.hibernate.search.engine.environment.bean.BeanReference<?>> references) {
        final BeanNotFoundException result = new BeanNotFoundException(String.format(getLoggingLocale(), multipleConfiguredBeanReferencesForType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(exposedType), references));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noConfiguredBeanReferenceForType$str() {
        return "HSEARCH000577: No beans defined for type '%1$s' in Hibernate Search's internal registry.";
    }
    @Override
    public final BeanNotFoundException noConfiguredBeanReferenceForType(final Class<?> exposedType) {
        final BeanNotFoundException result = new BeanNotFoundException(String.format(getLoggingLocale(), noConfiguredBeanReferenceForType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(exposedType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noConfiguredBeanReferenceForTypeAndName$str() {
        return "HSEARCH000578: No beans defined for type '%1$s' and name '%2$s' in Hibernate Search's internal registry.";
    }
    @Override
    public final BeanNotFoundException noConfiguredBeanReferenceForTypeAndName(final Class<?> exposedType, final String nameReference) {
        final BeanNotFoundException result = new BeanNotFoundException(String.format(getLoggingLocale(), noConfiguredBeanReferenceForTypeAndName$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(exposedType), nameReference));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotResolveBeanReference3$str() {
        return "HSEARCH000579: Unable to resolve bean reference to type '%1$s' and name '%2$s'. %3$s";
    }
    @Override
    public final BeanNotFoundException cannotResolveBeanReference(final Class<?> typeReference, final String nameReference, final String failureMessages, final RuntimeException mainFailure, final Collection<? extends RuntimeException> otherFailures) {
        final BeanNotFoundException result = new BeanNotFoundException(String.format(getLoggingLocale(), cannotResolveBeanReference3$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(typeReference), nameReference, failureMessages), mainFailure);
        _copyStackTraceMinusOne(result);
        otherFailures.forEach($otherFailuresVar -> result.addSuppressed($otherFailuresVar));
        return result;
    }
    protected String cannotResolveBeanReference2$str() {
        return "HSEARCH000580: Unable to resolve bean reference to type '%1$s'. %2$s";
    }
    @Override
    public final BeanNotFoundException cannotResolveBeanReference(final Class<?> typeReference, final String failureMessages, final RuntimeException beanProviderFailure, final Collection<? extends RuntimeException> otherFailures) {
        final BeanNotFoundException result = new BeanNotFoundException(String.format(getLoggingLocale(), cannotResolveBeanReference2$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(typeReference), failureMessages), beanProviderFailure);
        _copyStackTraceMinusOne(result);
        otherFailures.forEach($otherFailuresVar -> result.addSuppressed($otherFailuresVar));
        return result;
    }
    protected String failedToResolveBeanUsingInternalRegistry$str() {
        return "Failed to resolve bean from Hibernate Search's internal registry with exception: %1$s";
    }
    @Override
    public final String failedToResolveBeanUsingInternalRegistry(final String exceptionMessage) {
        return String.format(getLoggingLocale(), failedToResolveBeanUsingInternalRegistry$str(), exceptionMessage);
    }
    protected String failedToResolveBeanUsingBeanManager$str() {
        return "Failed to resolve bean from bean manager with exception: %1$s";
    }
    @Override
    public final String failedToResolveBeanUsingBeanManager(final String exceptionMessage) {
        return String.format(getLoggingLocale(), failedToResolveBeanUsingBeanManager$str(), exceptionMessage);
    }
    protected String failedToResolveBeanUsingReflection$str() {
        return "Failed to resolve bean using reflection with exception: %1$s";
    }
    @Override
    public final String failedToResolveBeanUsingReflection(final String exceptionMessage) {
        return String.format(getLoggingLocale(), failedToResolveBeanUsingReflection$str(), exceptionMessage);
    }
    protected String unableToCreateBeanUsingReflection$str() {
        return "HSEARCH000589: Unable to create bean using reflection: %1$s";
    }
    @Override
    public final BeanNotFoundException unableToCreateBeanUsingReflection(final String causeMessage, final Exception e) {
        final BeanNotFoundException result = new BeanNotFoundException(String.format(getLoggingLocale(), unableToCreateBeanUsingReflection$str(), causeMessage), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noConfiguredBeanManager$str() {
        return "HSEARCH000590: No configured bean manager.";
    }
    @Override
    public final BeanNotFoundException noConfiguredBeanManager() {
        final BeanNotFoundException result = new BeanNotFoundException(String.format(getLoggingLocale(), noConfiguredBeanManager$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToResolveToClassName$str() {
        return "HSEARCH000591: Unable to resolve '%2$s' to a class extending '%1$s': %3$s";
    }
    @Override
    public final BeanNotFoundException unableToResolveToClassName(final Class<?> typReference, final String nameReference, final String causeMessage, final Exception e) {
        final BeanNotFoundException result = new BeanNotFoundException(String.format(getLoggingLocale(), unableToResolveToClassName$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(typReference), nameReference, causeMessage), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidBeanRetrieval$str() {
        return "HSEARCH000592: Invalid bean reference: '%1$s'. The reference is prefixed with '%2$s', which is not a valid bean retrieval prefix. If you want to reference a bean by name, and the name contains a colon, use 'bean:%1$s'. Otherwise, use a valid bean retrieval prefix among the following: %3$s.";
    }
    @Override
    public final BeanNotFoundException invalidBeanRetrieval(final String beanReference, final String invalidPrefix, final List<String> validPrefixes, final Exception e) {
        final BeanNotFoundException result = new BeanNotFoundException(String.format(getLoggingLocale(), invalidBeanRetrieval$str(), beanReference, invalidPrefix, validPrefixes), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToCloseSavedValue$str() {
        return "HSEARCH000612: Unable to close saved value for key %1$s: %2$s";
    }
    @Override
    public final SearchException unableToCloseSavedValue(final String keyName, final String message, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToCloseSavedValue$str(), keyName, message), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noIntegrationBecauseInitializationNotComplete$str() {
        return "HSEARCH000613: Unable to access the Search integration: initialization hasn't completed yet.";
    }
    @Override
    public final SearchException noIntegrationBecauseInitializationNotComplete() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), noIntegrationBecauseInitializationNotComplete$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void interruptedWorkError(final Runnable r) {
        log.logf(FQCN, ERROR, null, interruptedWorkError$str(), r);
    }
    protected String interruptedWorkError$str() {
        return "HSEARCH000628: Work discarded, thread was interrupted while waiting for space to schedule: %1$s";
    }
    @Override
    public final void exceptionOccurred(final String errorMsg, final Throwable exceptionThatOccurred) {
        log.logf(FQCN, ERROR, exceptionThatOccurred, exceptionOccurred$str(), errorMsg);
    }
    protected String exceptionOccurred$str() {
        return "HSEARCH000629: %1$s";
    }
}
