/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.lowlevel.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.facet.Facets;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.NumericUtils;
import org.hibernate.search.backend.lucene.lowlevel.comparator.impl.DoubleValuesSourceComparator;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.DoubleMultiValuesToSingleValuesSource;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.JoiningLongMultiValuesSource;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.LongMultiValuesSource;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.MultiValueMode;
import org.hibernate.search.backend.lucene.lowlevel.facet.impl.FacetCountsUtils;
import org.hibernate.search.backend.lucene.lowlevel.facet.impl.LongMultiValueFacetCounts;
import org.hibernate.search.backend.lucene.lowlevel.facet.impl.LongMultiValueRangeFacetCounts;
import org.hibernate.search.backend.lucene.lowlevel.join.impl.NestedDocsProvider;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.LuceneNumericDomain;
import org.hibernate.search.util.common.data.Range;

public class LuceneDoubleDomain
implements LuceneNumericDomain<Double> {
    private static final LuceneNumericDomain<Double> INSTANCE = new LuceneDoubleDomain();

    public static LuceneNumericDomain<Double> get() {
        return INSTANCE;
    }

    @Override
    public Double getMinValue() {
        return -1.7976931348623157E308;
    }

    @Override
    public Double getMaxValue() {
        return Double.MAX_VALUE;
    }

    @Override
    public Double getPreviousValue(Double value) {
        return Math.nextDown(value);
    }

    @Override
    public Double getNextValue(Double value) {
        return Math.nextUp(value);
    }

    @Override
    public Comparator<Double> createComparator() {
        return Comparator.naturalOrder();
    }

    @Override
    public Query createExactQuery(String absoluteFieldPath, Double value) {
        return DoublePoint.newExactQuery((String)absoluteFieldPath, (double)value);
    }

    @Override
    public Query createRangeQuery(String absoluteFieldPath, Double lowerLimit, Double upperLimit) {
        return DoublePoint.newRangeQuery((String)absoluteFieldPath, (double)lowerLimit, (double)upperLimit);
    }

    @Override
    public Query createSetQuery(String absoluteFieldPath, Collection<Double> values) {
        return DoublePoint.newSetQuery((String)absoluteFieldPath, values);
    }

    @Override
    public Double sortedDocValueToTerm(long longValue) {
        return NumericUtils.sortableLongToDouble((long)longValue);
    }

    @Override
    public double sortedDocValueToDouble(long longValue) {
        return this.sortedDocValueToTerm(longValue);
    }

    @Override
    public Double doubleToTerm(double doubleValue) {
        return doubleValue;
    }

    @Override
    public Facets createTermsFacetCounts(String absoluteFieldPath, FacetsCollector facetsCollector, NestedDocsProvider nestedDocsProvider) throws IOException {
        JoiningLongMultiValuesSource source = JoiningLongMultiValuesSource.fromLongField(absoluteFieldPath, nestedDocsProvider);
        return new LongMultiValueFacetCounts(absoluteFieldPath, source, facetsCollector);
    }

    @Override
    public Facets createRangeFacetCounts(String absoluteFieldPath, FacetsCollector facetsCollector, Collection<? extends Range<? extends Double>> ranges, NestedDocsProvider nestedDocsProvider) throws IOException {
        JoiningLongMultiValuesSource source = JoiningLongMultiValuesSource.fromLongField(absoluteFieldPath, nestedDocsProvider);
        return new LongMultiValueRangeFacetCounts(absoluteFieldPath, (LongMultiValuesSource)source, facetsCollector, FacetCountsUtils.createLongRangesForFloatingPointValues(ranges, NumericUtils::doubleToSortableLong, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
    }

    @Override
    public IndexableField createIndexField(String absoluteFieldPath, Double numericValue) {
        return new DoublePoint(absoluteFieldPath, new double[]{numericValue});
    }

    @Override
    public IndexableField createSortedDocValuesField(String absoluteFieldPath, Double numericValue) {
        return new SortedNumericDocValuesField(absoluteFieldPath, NumericUtils.doubleToSortableLong((double)numericValue));
    }

    @Override
    public FieldComparator<Double> createFieldComparator(String fieldName, int numHits, Double missingValue, boolean reversed, Pruning pruning, MultiValueMode multiValueMode, NestedDocsProvider nestedDocsProvider) {
        DoubleMultiValuesToSingleValuesSource source = DoubleMultiValuesToSingleValuesSource.fromDoubleField(fieldName, multiValueMode, nestedDocsProvider);
        return new DoubleValuesSourceComparator(numHits, fieldName, missingValue, reversed, pruning, source);
    }
}

