/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.aggregation.impl;

import org.hibernate.search.backend.lucene.lowlevel.aggregation.collector.impl.AggregationFunctionCollector;
import org.hibernate.search.backend.lucene.lowlevel.aggregation.collector.impl.Count;
import org.hibernate.search.backend.lucene.lowlevel.aggregation.collector.impl.CountCollectorFactory;
import org.hibernate.search.backend.lucene.lowlevel.aggregation.collector.impl.SumCollectorFactory;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorKey;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.JoiningLongMultiValuesSource;
import org.hibernate.search.backend.lucene.search.aggregation.impl.AggregationExtractContext;
import org.hibernate.search.backend.lucene.search.aggregation.impl.AggregationRequestContext;
import org.hibernate.search.backend.lucene.search.aggregation.impl.LuceneSearchAggregation;
import org.hibernate.search.backend.lucene.search.common.impl.AbstractLuceneCodecAwareSearchQueryElementFactory;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexValueFieldContext;
import org.hibernate.search.backend.lucene.types.aggregation.impl.AbstractLuceneMetricNumericFieldAggregation;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneNumericFieldCodec;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.cfg.spi.NumberUtils;
import org.hibernate.search.engine.search.aggregation.spi.FieldMetricAggregationBuilder;

public class LuceneAvgNumericFieldAggregation<F, E extends Number, K>
extends AbstractLuceneMetricNumericFieldAggregation<F, E, K> {
    protected CollectorKey<AggregationFunctionCollector<Count>, Long> countCollectorKey;

    public static <F> Factory<F> factory(AbstractLuceneNumericFieldCodec<F, ?> codec) {
        return new Factory<F>(codec);
    }

    LuceneAvgNumericFieldAggregation(Builder<F, E, K> builder) {
        super(builder);
    }

    @Override
    void fillCollectors(JoiningLongMultiValuesSource source, AggregationRequestContext context) {
        SumCollectorFactory sumCollectorFactory = new SumCollectorFactory(source);
        CountCollectorFactory countCollectorFactory = new CountCollectorFactory(source);
        this.collectorKey = sumCollectorFactory.getCollectorKey();
        this.countCollectorKey = countCollectorFactory.getCollectorKey();
        context.requireCollector(sumCollectorFactory);
        context.requireCollector(countCollectorFactory);
    }

    public static class Factory<F>
    extends AbstractLuceneCodecAwareSearchQueryElementFactory<FieldMetricAggregationBuilder.TypeSelector, F, AbstractLuceneNumericFieldCodec<F, ?>> {
        protected Factory(AbstractLuceneNumericFieldCodec<F, ?> codec) {
            super(codec);
        }

        @Override
        public FieldMetricAggregationBuilder.TypeSelector create(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            return new FunctionTypeSelector((AbstractLuceneNumericFieldCodec)this.codec, scope, field);
        }
    }

    private static class Builder<F, E extends Number, K>
    extends AbstractLuceneMetricNumericFieldAggregation.Builder<F, E, K> {
        public Builder(AbstractLuceneNumericFieldCodec<F, E> codec, LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field, AbstractLuceneMetricNumericFieldAggregation.AbstractExtractorBuilder<F, E, K> extractorCreator) {
            super(codec, scope, field, extractorCreator);
        }

        @Override
        public AbstractLuceneMetricNumericFieldAggregation<F, E, K> build() {
            return new LuceneAvgNumericFieldAggregation(this);
        }
    }

    private static class FunctionTypeSelector<F, E extends Number>
    extends AbstractLuceneMetricNumericFieldAggregation.TypeSelector<F, E>
    implements FieldMetricAggregationBuilder.TypeSelector {
        protected FunctionTypeSelector(AbstractLuceneNumericFieldCodec<F, E> codec, LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            super(codec, scope, field);
        }

        @Override
        protected <T> Builder<F, E, T> getFtBuilder(AbstractLuceneMetricNumericFieldAggregation.AbstractExtractorBuilder<F, E, T> extractorCreator) {
            return new Builder<F, E, T>(this.codec, this.scope, this.field, extractorCreator);
        }

        @Override
        protected <T> AbstractLuceneMetricNumericFieldAggregation.AbstractExtractorBuilder<F, E, T> extractor(ProjectionConverter<F, ? extends T> projectionConverter) {
            return new LuceneNumericMetricFieldAggregationExtraction.Builder(projectionConverter);
        }

        @Override
        protected <T> AbstractLuceneMetricNumericFieldAggregation.AbstractExtractorBuilder<F, E, T> rawExtractor(ProjectionConverter<?, ? extends T> projectionConverter) {
            return new LuceneNumericMetricFieldAggregationRawExtraction.Builder();
        }

        @Override
        protected <T> AbstractLuceneMetricNumericFieldAggregation.AbstractExtractorBuilder<F, E, T> doubleExtractor() {
            return new LuceneNumericMetricFieldAggregationDoubleExtraction.Builder();
        }
    }

    private static class LuceneNumericMetricFieldAggregationRawExtraction<E extends Number>
    implements LuceneSearchAggregation.Extractor<E> {
        private final CollectorKey<?, Long> collectorKey;
        private final CollectorKey<?, Long> countCollectorKey;
        private final AbstractLuceneNumericFieldCodec<?, E> codec;

        private LuceneNumericMetricFieldAggregationRawExtraction(CollectorKey<?, Long> collectorKey, CollectorKey<?, Long> countCollectorKey, AbstractLuceneNumericFieldCodec<?, E> codec) {
            this.collectorKey = collectorKey;
            this.countCollectorKey = countCollectorKey;
            this.codec = codec;
        }

        @Override
        public E extract(AggregationExtractContext context) {
            Long collector = context.getFacets(this.collectorKey);
            Long counts = context.getFacets(this.countCollectorKey);
            Double avg = (double)collector.longValue() / (double)counts.longValue();
            collector = NumberUtils.toLong((Double)avg);
            return this.codec.getDomain().sortedDocValueToTerm(collector);
        }

        private static class Builder<F, E extends Number, K>
        extends AbstractLuceneMetricNumericFieldAggregation.AbstractExtractorBuilder<F, E, K> {
            private Builder() {
            }

            @Override
            LuceneSearchAggregation.Extractor<K> extractor(AbstractLuceneMetricNumericFieldAggregation<F, E, K> aggregation) {
                return new LuceneNumericMetricFieldAggregationRawExtraction(aggregation.collectorKey, ((LuceneAvgNumericFieldAggregation)aggregation).countCollectorKey, aggregation.codec);
            }
        }
    }

    private static class LuceneNumericMetricFieldAggregationDoubleExtraction<F, E extends Number>
    implements LuceneSearchAggregation.Extractor<Double> {
        private final CollectorKey<?, Long> collectorKey;
        private final CollectorKey<?, Long> countCollectorKey;
        private final AbstractLuceneNumericFieldCodec<F, E> codec;

        private LuceneNumericMetricFieldAggregationDoubleExtraction(CollectorKey<?, Long> collectorKey, CollectorKey<?, Long> countCollectorKey, AbstractLuceneNumericFieldCodec<F, E> codec) {
            this.collectorKey = collectorKey;
            this.countCollectorKey = countCollectorKey;
            this.codec = codec;
        }

        @Override
        public Double extract(AggregationExtractContext context) {
            double collector = this.codec.sortedDocValueToDouble(context.getFacets(this.collectorKey));
            Long counts = context.getFacets(this.countCollectorKey);
            return collector / (double)counts.longValue();
        }

        private static class Builder<F, E extends Number, K>
        extends AbstractLuceneMetricNumericFieldAggregation.AbstractExtractorBuilder<F, E, K> {
            private Builder() {
            }

            @Override
            LuceneSearchAggregation.Extractor<K> extractor(AbstractLuceneMetricNumericFieldAggregation<F, E, K> aggregation) {
                return new LuceneNumericMetricFieldAggregationDoubleExtraction(aggregation.collectorKey, ((LuceneAvgNumericFieldAggregation)aggregation).countCollectorKey, aggregation.codec);
            }
        }
    }

    private static class LuceneNumericMetricFieldAggregationExtraction<F, E extends Number, K>
    implements LuceneSearchAggregation.Extractor<K> {
        private final CollectorKey<?, Long> collectorKey;
        private final CollectorKey<?, Long> countCollectorKey;
        private final AbstractLuceneNumericFieldCodec<F, E> codec;
        private final ProjectionConverter<F, ? extends K> fromFieldValueConverter;

        private LuceneNumericMetricFieldAggregationExtraction(CollectorKey<?, Long> collectorKey, CollectorKey<?, Long> countCollectorKey, AbstractLuceneNumericFieldCodec<F, E> codec, ProjectionConverter<F, ? extends K> fromFieldValueConverter) {
            this.collectorKey = collectorKey;
            this.countCollectorKey = countCollectorKey;
            this.codec = codec;
            this.fromFieldValueConverter = fromFieldValueConverter;
        }

        @Override
        public K extract(AggregationExtractContext context) {
            Long collector = context.getFacets(this.collectorKey);
            Long counts = context.getFacets(this.countCollectorKey);
            Double avg = (double)collector.longValue() / (double)counts.longValue();
            collector = NumberUtils.toLong((Double)avg);
            E e = this.codec.getDomain().sortedDocValueToTerm(collector);
            Object decode = this.codec.decode(e);
            return (K)this.fromFieldValueConverter.fromDocumentValue(decode, context.fromDocumentValueConvertContext());
        }

        private static class Builder<F, E extends Number, K>
        extends AbstractLuceneMetricNumericFieldAggregation.AbstractExtractorBuilder<F, E, K> {
            private final ProjectionConverter<F, ? extends K> fromFieldValueConverter;

            private Builder(ProjectionConverter<F, ? extends K> fromFieldValueConverter) {
                this.fromFieldValueConverter = fromFieldValueConverter;
            }

            @Override
            LuceneSearchAggregation.Extractor<K> extractor(AbstractLuceneMetricNumericFieldAggregation<F, E, K> aggregation) {
                return new LuceneNumericMetricFieldAggregationExtraction(aggregation.collectorKey, ((LuceneAvgNumericFieldAggregation)aggregation).countCollectorKey, aggregation.codec, this.fromFieldValueConverter);
            }
        }
    }
}

