/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.logging.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.hibernate.search.backend.lucene.logging.impl.IndexingLog;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.Logger;

public class IndexingLog_$logger
implements IndexingLog,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = IndexingLog_$logger.class.getName();
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;

    public IndexingLog_$logger(Logger log) {
        this.log = log;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String unableToIndexEntry$str() {
        return "HSEARCH600016: Unable to index entity of type '%2$s' with identifier '%3$s' and tenant identifier '%1$s': %4$s";
    }

    @Override
    public final SearchException unableToIndexEntry(String tenantId, String entityTypeName, Object entityIdentifier, String causeMessage, EventContext context, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToIndexEntry$str(), tenantId, entityTypeName, entityIdentifier, causeMessage), (Throwable)cause, context);
        IndexingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String unableToDeleteEntryFromIndex$str() {
        return "HSEARCH600017: Unable to delete entity of type '%2$s' with identifier '%3$s' and tenant identifier '%1$s': %4$s";
    }

    @Override
    public final SearchException unableToDeleteEntryFromIndex(String tenantId, String entityTypeName, Object entityIdentifier, String causeMessage, EventContext context, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToDeleteEntryFromIndex$str(), tenantId, entityTypeName, entityIdentifier, causeMessage), (Throwable)cause, context);
        IndexingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToCommitIndex$str() {
        return "HSEARCH600019: Unable to commit: %1$s";
    }

    @Override
    public final SearchException unableToCommitIndex(String causeMessage, EventContext context, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToCommitIndex$str(), causeMessage), (Throwable)cause, context);
        IndexingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidFieldForDocumentElement$str() {
        return "HSEARCH600039: Invalid field reference for this document element: this document element has path '%1$s', but the referenced field has a parent with path '%2$s'.";
    }

    @Override
    public final SearchException invalidFieldForDocumentElement(String expectedPath, String actualPath) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidFieldForDocumentElement$str(), expectedPath, actualPath));
        IndexingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidFieldPath$str() {
        return "HSEARCH600049: Invalid field path; expected path '%1$s', got '%2$s'.";
    }

    @Override
    public final SearchException invalidFieldPath(String expectedPath, String actualPath) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidFieldPath$str(), expectedPath, actualPath));
        IndexingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotConvertDslParameter$str() {
        return "HSEARCH600050: Unable to convert DSL argument: %1$s";
    }

    @Override
    public final SearchException cannotConvertDslParameter(String errorMessage, Exception cause, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotConvertDslParameter$str(), errorMessage), (Throwable)cause, context);
        IndexingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String multipleValuesForSingleValuedField$str() {
        return "HSEARCH600074: Multiple values assigned to field '%1$s': this field is single-valued. Declare the field as multi-valued in order to allow this.";
    }

    @Override
    public final SearchException multipleValuesForSingleValuedField(String absoluteFieldPath) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multipleValuesForSingleValuedField$str(), absoluteFieldPath));
        IndexingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String scaledNumberTooLarge$str() {
        return "HSEARCH600081: Unable to encode value '%1$s': this field type only supports values ranging from '%2$s' to '%3$s'. If you want to encode values that are outside this range, change the decimal scale for this field. Do not forget to reindex all your data after changing the decimal scale.";
    }

    @Override
    public final SearchException scaledNumberTooLarge(Number value, Number min, Number max) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.scaledNumberTooLarge$str(), value, min, max));
        IndexingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidFieldValueType$str() {
        return "HSEARCH600126: Invalid value type. This field's values are of type '%1$s', which is not assignable from '%2$s'.";
    }

    @Override
    public final SearchException invalidFieldValueType(Class<?> fieldValueType, Class<?> invalidValueType, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidFieldValueType$str(), new ClassFormatter(fieldValueType), new ClassFormatter(invalidValueType)), context);
        IndexingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownFieldForIndexing$str() {
        return "HSEARCH600127: Unknown field '%1$s'.";
    }

    @Override
    public final SearchException unknownFieldForIndexing(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownFieldForIndexing$str(), absoluteFieldPath), context);
        IndexingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String vectorCosineZeroMagnitudeNotAcceptable$str() {
        return "HSEARCH600184: The cosine vector similarity cannot process vectors with 0 magnitude. The vector violating this constraint is %1$s.";
    }

    @Override
    public final SearchException vectorCosineZeroMagnitudeNotAcceptable(Object vector) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.vectorCosineZeroMagnitudeNotAcceptable$str(), vector));
        IndexingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String vectorDotProductNonUnitMagnitudeNotAcceptable$str() {
        return "HSEARCH600185: The dot product vector similarity cannot process non-unit magnitude vectors. The vector violating this constraint is %1$s.";
    }

    @Override
    public final SearchException vectorDotProductNonUnitMagnitudeNotAcceptable(Object vector) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.vectorDotProductNonUnitMagnitudeNotAcceptable$str(), vector));
        IndexingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }
}

