package org.hibernate.search.backend.lucene.logging.impl;

import java.util.Locale;
import java.nio.file.Path;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.HibernateSearchMultiReader;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import java.lang.Class;
import java.util.Arrays;
import org.apache.lucene.store.Directory;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class LuceneMiscLog_$logger extends DelegatingBasicLogger implements LuceneMiscLog, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = LuceneMiscLog_$logger.class.getName();
    public LuceneMiscLog_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void indexDirectoryNotFoundCreatingNewOne(final Path absolutePath) {
        super.log.logf(FQCN, INFO, null, indexDirectoryNotFoundCreatingNewOne$str(), absolutePath);
    }
    protected String indexDirectoryNotFoundCreatingNewOne$str() {
        return "HSEARCH000041: Index directory does not exist, creating: '%1$s'";
    }
    @Override
    public final void indexWriterResetAfterFailure(final EventContext context) {
        super.log.logf(FQCN, WARN, null, indexWriterResetAfterFailure$str(), new org.hibernate.search.util.common.logging.impl.EventContextFormatter(context));
    }
    protected String indexWriterResetAfterFailure$str() {
        return "HSEARCH000052: An index writer operation failed. Resetting the index writer and forcing release of locks. %1$s";
    }
    @Override
    public final void unableToCloseIndexReader(final EventContext context, final Exception e) {
        super.log.logf(FQCN, WARN, e, unableToCloseIndexReader$str(), new org.hibernate.search.util.common.logging.impl.EventContextFormatter(context));
    }
    protected String unableToCloseIndexReader$str() {
        return "HSEARCH000055: Unable to close the index reader. %1$s";
    }
    protected String unableToLoadResource$str() {
        return "HSEARCH000114: Resource does not exist in classpath: '%1$s'";
    }
    @Override
    public final SearchException unableToLoadResource(final String fileName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToLoadResource$str(), fileName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    @Override
    public final void lockingFailureDuringInitialization(final String directoryDescription, final EventContext context, final Exception e) {
        super.log.logf(FQCN, WARN, e, lockingFailureDuringInitialization$str(), directoryDescription);
    }
    protected String lockingFailureDuringInitialization$str() {
        return "HSEARCH000225: Unable to acquire lock on the index while initializing directory '%s'. Either the directory wasn't properly closed last time it was used due to a critical failure, or another instance of Hibernate Search is using it concurrently (which is not supported). If you experience indexing failures on this index you will need to remove the lock, and might need to rebuild the index.";
    }
    protected String unableToOpenIndexReaders$str() {
        return "HSEARCH000284: Unable to open index readers: %1$s";
    }
    @Override
    public final SearchException unableToOpenIndexReaders(final String causeMessage, final EventContext context, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToOpenIndexReaders$str(), causeMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String pathIsNotWriteableDirectory$str() {
        return "HSEARCH600001: Path '%1$s' exists but does not point to a writable directory.";
    }
    @Override
    public final SearchException pathIsNotWriteableDirectory(final Path rootDirectory) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), pathIsNotWriteableDirectory$str(), rootDirectory));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String luceneExtensionOnUnknownType$str() {
        return "HSEARCH600005: Invalid target for Lucene extension: '%1$s'. This extension can only be applied to components created by a Lucene backend.";
    }
    @Override
    public final SearchException luceneExtensionOnUnknownType(final Object context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), luceneExtensionOnUnknownType$str(), context));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToInitializeIndexDirectory$str() {
        return "HSEARCH600015: Unable to initialize index directory: %1$s";
    }
    @Override
    public final SearchException unableToInitializeIndexDirectory(final String causeMessage, final EventContext context, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToInitializeIndexDirectory$str(), causeMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String backendUnwrappingWithUnknownType$str() {
        return "HSEARCH600033: Invalid requested type for this backend: '%1$s'. Lucene backends can only be unwrapped to '%2$s'.";
    }
    @Override
    public final SearchException backendUnwrappingWithUnknownType(final Class<?> requestedClass, final Class<?> actualClass, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), backendUnwrappingWithUnknownType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(requestedClass), new org.hibernate.search.util.common.logging.impl.ClassFormatter(actualClass)), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String indexManagerUnwrappingWithUnknownType$str() {
        return "HSEARCH600051: Invalid requested type for this index manager: '%1$s'. Lucene index managers can only be unwrapped to '%2$s'.";
    }
    @Override
    public final SearchException indexManagerUnwrappingWithUnknownType(final Class<?> requestedClass, final Class<?> actualClass, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), indexManagerUnwrappingWithUnknownType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(requestedClass), new org.hibernate.search.util.common.logging.impl.ClassFormatter(actualClass)), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToShutdownShard$str() {
        return "HSEARCH600061: Unable to shut down index: %1$s";
    }
    @Override
    public final SearchException unableToShutdownShard(final String causeMessage, final EventContext context, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToShutdownShard$str(), causeMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToMergeSegments$str() {
        return "HSEARCH600078: Unable to merge index segments: %1$s";
    }
    @Override
    public final SearchException unableToMergeSegments(final String causeMessage, final EventContext context, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToMergeSegments$str(), causeMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToCloseIndexWriterAfterFailures$str() {
        return "HSEARCH600079: Unable to close the index writer after write failures: %1$s";
    }
    @Override
    public final SearchException unableToCloseIndexWriterAfterFailures(final String causeMessage, final EventContext context, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToCloseIndexWriterAfterFailures$str(), causeMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingIndex$str() {
        return "HSEARCH600109: Index does not exist for directory '%1$s'";
    }
    @Override
    public final SearchException missingIndex(final Directory directory, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingIndex$str(), directory), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToValidateIndexDirectory$str() {
        return "HSEARCH600110: Unable to validate index directory: %1$s";
    }
    @Override
    public final SearchException unableToValidateIndexDirectory(final String causeMessage, final EventContext context, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToValidateIndexDirectory$str(), causeMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToDropIndexDirectory$str() {
        return "HSEARCH600111: Unable to drop index directory: %1$s";
    }
    @Override
    public final SearchException unableToDropIndexDirectory(final String causeMessage, final EventContext context, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToDropIndexDirectory$str(), causeMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String uncommittedOperationsBecauseOfFailure$str() {
        return "HSEARCH600118: A failure occurred during a low-level write operation and the index writer had to be reset. Some write operations may have been lost as a result. Failure: %1$s";
    }
    @Override
    public final SearchException uncommittedOperationsBecauseOfFailure(final String causeMessage, final EventContext context, final Throwable cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), uncommittedOperationsBecauseOfFailure$str(), causeMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToComputeIndexSize$str() {
        return "HSEARCH600141: Unable to compute size of index: %1$s";
    }
    @Override
    public final SearchException unableToComputeIndexSize(final String causeMessage, final EventContext context, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToComputeIndexSize$str(), causeMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToStartShard$str() {
        return "HSEARCH600154: Unable to start index: %1$s";
    }
    @Override
    public final SearchException unableToStartShard(final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToStartShard$str(), causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nonblockingOperationSubmitterNotSupported$str() {
        return "HSEARCH600156: Nonblocking operation submitter is not supported.";
    }
    @Override
    public final SearchException nonblockingOperationSubmitterNotSupported() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), nonblockingOperationSubmitterNotSupported$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToExportSchema$str() {
        return "HSEARCH600157: Unable to export the schema for '%1$s' index: %2$s";
    }
    @Override
    public final SearchException unableToExportSchema(final String indexName, final String message, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToExportSchema$str(), indexName, message), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToRefresh$str() {
        return "HSEARCH600187: Unable to refresh an index reader: %1$s";
    }
    @Override
    public final SearchException unableToRefresh(final String causeMessage, final EventContext context, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToRefresh$str(), causeMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void closingMultiReader(final HibernateSearchMultiReader hibernateSearchMultiReader) {
        super.log.logf(FQCN, TRACE, null, closingMultiReader$str(), hibernateSearchMultiReader);
    }
    protected String closingMultiReader$str() {
        return "HSEARCH600189: Closing MultiReader: %s";
    }
    @Override
    public final void closedMultiReader(final HibernateSearchMultiReader hibernateSearchMultiReader) {
        super.log.logf(FQCN, TRACE, null, closedMultiReader$str(), hibernateSearchMultiReader);
    }
    protected String closedMultiReader$str() {
        return "HSEARCH600190: MultiReader closed: %s";
    }
    @Override
    public final void closedIndexWriter() {
        super.log.logf(FQCN, TRACE, null, closedIndexWriter$str());
    }
    protected String closedIndexWriter$str() {
        return "HSEARCH600191: IndexWriter closed";
    }
    @Override
    public final void openedIndexWriter() {
        super.log.logf(FQCN, TRACE, null, openedIndexWriter$str());
    }
    protected String openedIndexWriter$str() {
        return "HSEARCH600192: IndexWriter opened";
    }
    @Override
    public final void indexWriterSetParameter(final String settingName, final Object value, final String context) {
        super.log.logf(FQCN, DEBUG, null, indexWriterSetParameter$str(), settingName, value, context);
    }
    protected String indexWriterSetParameter$str() {
        return "HSEARCH600193: Set index writer parameter %s to value : %s. %s";
    }
}
