package org.hibernate.search.backend.lucene.logging.impl;

import java.util.Locale;
import org.hibernate.search.util.common.reporting.EventContext;
import java.io.Serializable;
import java.lang.Number;
import org.hibernate.search.util.common.SearchException;
import java.lang.Object;
import java.lang.Class;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;
import java.lang.Exception;

/**
 * Warning this class consists of generated code.
 */
public class IndexingLog_$logger implements IndexingLog, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = IndexingLog_$logger.class.getName();
    public IndexingLog_$logger(final Logger log) {
        this.log = log;
    }
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String unableToIndexEntry$str() {
        return "HSEARCH600016: Unable to index entity of type '%2$s' with identifier '%3$s' and tenant identifier '%1$s': %4$s";
    }
    @Override
    public final SearchException unableToIndexEntry(final String tenantId, final String entityTypeName, final Object entityIdentifier, final String causeMessage, final EventContext context, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToIndexEntry$str(), tenantId, entityTypeName, entityIdentifier, causeMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String unableToDeleteEntryFromIndex$str() {
        return "HSEARCH600017: Unable to delete entity of type '%2$s' with identifier '%3$s' and tenant identifier '%1$s': %4$s";
    }
    @Override
    public final SearchException unableToDeleteEntryFromIndex(final String tenantId, final String entityTypeName, final Object entityIdentifier, final String causeMessage, final EventContext context, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToDeleteEntryFromIndex$str(), tenantId, entityTypeName, entityIdentifier, causeMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToCommitIndex$str() {
        return "HSEARCH600019: Unable to commit: %1$s";
    }
    @Override
    public final SearchException unableToCommitIndex(final String causeMessage, final EventContext context, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToCommitIndex$str(), causeMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidFieldForDocumentElement$str() {
        return "HSEARCH600039: Invalid field reference for this document element: this document element has path '%1$s', but the referenced field has a parent with path '%2$s'.";
    }
    @Override
    public final SearchException invalidFieldForDocumentElement(final String expectedPath, final String actualPath) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFieldForDocumentElement$str(), expectedPath, actualPath));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidFieldPath$str() {
        return "HSEARCH600049: Invalid field path; expected path '%1$s', got '%2$s'.";
    }
    @Override
    public final SearchException invalidFieldPath(final String expectedPath, final String actualPath) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFieldPath$str(), expectedPath, actualPath));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotConvertDslParameter$str() {
        return "HSEARCH600050: Unable to convert DSL argument: %1$s";
    }
    @Override
    public final SearchException cannotConvertDslParameter(final String errorMessage, final Exception cause, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotConvertDslParameter$str(), errorMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multipleValuesForSingleValuedField$str() {
        return "HSEARCH600074: Multiple values assigned to field '%1$s': this field is single-valued. Declare the field as multi-valued in order to allow this.";
    }
    @Override
    public final SearchException multipleValuesForSingleValuedField(final String absoluteFieldPath) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multipleValuesForSingleValuedField$str(), absoluteFieldPath));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String scaledNumberTooLarge$str() {
        return "HSEARCH600081: Unable to encode value '%1$s': this field type only supports values ranging from '%2$s' to '%3$s'. If you want to encode values that are outside this range, change the decimal scale for this field. Do not forget to reindex all your data after changing the decimal scale.";
    }
    @Override
    public final SearchException scaledNumberTooLarge(final Number value, final Number min, final Number max) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), scaledNumberTooLarge$str(), value, min, max));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidFieldValueType$str() {
        return "HSEARCH600126: Invalid value type. This field's values are of type '%1$s', which is not assignable from '%2$s'.";
    }
    @Override
    public final SearchException invalidFieldValueType(final Class<?> fieldValueType, final Class<?> invalidValueType, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFieldValueType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(fieldValueType), new org.hibernate.search.util.common.logging.impl.ClassFormatter(invalidValueType)), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownFieldForIndexing$str() {
        return "HSEARCH600127: Unknown field '%1$s'.";
    }
    @Override
    public final SearchException unknownFieldForIndexing(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownFieldForIndexing$str(), absoluteFieldPath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String vectorCosineZeroMagnitudeNotAcceptable$str() {
        return "HSEARCH600184: The cosine vector similarity cannot process vectors with 0 magnitude. The vector violating this constraint is %1$s.";
    }
    @Override
    public final SearchException vectorCosineZeroMagnitudeNotAcceptable(final Object vector) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), vectorCosineZeroMagnitudeNotAcceptable$str(), vector));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String vectorDotProductNonUnitMagnitudeNotAcceptable$str() {
        return "HSEARCH600185: The dot product vector similarity cannot process non-unit magnitude vectors. The vector violating this constraint is %1$s.";
    }
    @Override
    public final SearchException vectorDotProductNonUnitMagnitudeNotAcceptable(final Object vector) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), vectorDotProductNonUnitMagnitudeNotAcceptable$str(), vector));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
