package org.hibernate.search.backend.lucene.logging.impl;

import java.util.Locale;
import java.io.Serializable;
import java.util.Set;
import org.jboss.logging.DelegatingBasicLogger;
import org.hibernate.search.util.common.SearchException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.hibernate.search.util.common.reporting.EventContext;
import org.apache.lucene.util.Version;
import org.jboss.logging.BasicLogger;
import java.util.Collection;
import java.util.List;
import java.lang.Object;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class ConfigurationLog_$logger extends DelegatingBasicLogger implements ConfigurationLog, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ConfigurationLog_$logger.class.getName();
    public ConfigurationLog_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void recommendConfiguringLuceneVersion(final String key, final Version latest, final EventContext context) {
        super.log.logf(FQCN, WARN, null, recommendConfiguringLuceneVersion$str(), key, latest, new org.hibernate.search.util.common.logging.impl.EventContextFormatter(context));
    }
    protected String recommendConfiguringLuceneVersion$str() {
        return "HSEARCH000075: Missing value for configuration property '%1$s': using LATEST (currently '%2$s'). %3$s";
    }
    protected String illegalLuceneVersionFormat$str() {
        return "HSEARCH000228: Unable to parse '%1$ss' into a Lucene version: %2$s";
    }
    @Override
    public final SearchException illegalLuceneVersionFormat(final String property, final String luceneErrorMessage, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), illegalLuceneVersionFormat$str(), property, luceneErrorMessage), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String invalidMultiTenancyStrategyName$str() {
        return "HSEARCH600030: Invalid multi-tenancy strategy name: '%1$s'. Valid names are: %2$s.";
    }
    @Override
    public final SearchException invalidMultiTenancyStrategyName(final String invalidRepresentation, final List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidMultiTenancyStrategyName$str(), invalidRepresentation, validRepresentations));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String tenantIdProvidedButMultiTenancyDisabled$str() {
        return "HSEARCH600031: Invalid tenant identifiers: '%1$s'. No tenant identifier is expected, because multi-tenancy is disabled for this backend.";
    }
    @Override
    public final SearchException tenantIdProvidedButMultiTenancyDisabled(final Set<String> tenantId, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), tenantIdProvidedButMultiTenancyDisabled$str(), tenantId), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multiTenancyEnabledButNoTenantIdProvided$str() {
        return "HSEARCH600032: Missing tenant identifier. A tenant identifier is expected, because multi-tenancy is enabled for this backend.";
    }
    @Override
    public final SearchException multiTenancyEnabledButNoTenantIdProvided(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multiTenancyEnabledButNoTenantIdProvided$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidFileSystemAccessStrategyName$str() {
        return "HSEARCH600087: Invalid filesystem access strategy name: '%1$s'. Valid names are: %2$s.";
    }
    @Override
    public final SearchException invalidFileSystemAccessStrategyName(final String invalidRepresentation, final List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFileSystemAccessStrategyName$str(), invalidRepresentation, validRepresentations));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidLockingStrategyName$str() {
        return "HSEARCH600088: Invalid locking strategy name: '%1$s'. Valid names are: %2$s.";
    }
    @Override
    public final SearchException invalidLockingStrategyName(final String invalidRepresentation, final List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidLockingStrategyName$str(), invalidRepresentation, validRepresentations));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingShardIdentifiersAfterShardingStrategyInitialization$str() {
        return "HSEARCH600089: Incorrect sharding strategy implementation: strategy '%1$s' did not declare any shard identifiers during initialization. Declare shard identifiers using context.shardIdentifiers(...) or, if sharding is disabled, call context.disableSharding().";
    }
    @Override
    public final SearchException missingShardIdentifiersAfterShardingStrategyInitialization(final Object strategy) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingShardIdentifiersAfterShardingStrategyInitialization$str(), strategy));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingPropertyValueForShardingStrategy$str() {
        return "HSEARCH600090: When using sharding strategy '%1$s', this configuration property must be set.";
    }
    @Override
    public final SearchException missingPropertyValueForShardingStrategy(final String strategyName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingPropertyValueForShardingStrategy$str(), strategyName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidRoutingKeyForExplicitShardingStrategy$str() {
        return "HSEARCH600091: Invalid routing key: '%1$s'. Valid keys are: %2$s.";
    }
    @Override
    public final SearchException invalidRoutingKeyForExplicitShardingStrategy(final String invalidKey, final Collection<String> validKeys) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidRoutingKeyForExplicitShardingStrategy$str(), invalidKey, validKeys));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidIOStrategyName$str() {
        return "HSEARCH600108: Invalid I/O strategy name: '%1$s'. Valid names are: %2$s.";
    }
    @Override
    public final SearchException invalidIOStrategyName(final String invalidRepresentation, final List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidIOStrategyName$str(), invalidRepresentation, validRepresentations));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalIndexWriterSetting$str() {
        return "HSEARCH600123: Invalid value for IndexWriter setting '%1$s': '%2$s'. %3$s";
    }
    @Override
    public final SearchException illegalIndexWriterSetting(final String settingName, final Object settingValue, final String message, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), illegalIndexWriterSetting$str(), settingName, settingValue, message), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalMergePolicySetting$str() {
        return "HSEARCH600124: Invalid value for merge policy setting '%1$s': '%2$s'. %3$s";
    }
    @Override
    public final SearchException illegalMergePolicySetting(final String settingName, final Object settingValue, final String message, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), illegalMergePolicySetting$str(), settingName, settingValue, message), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToApplyQueryCacheConfiguration$str() {
        return "HSEARCH600146: Unable to apply query caching configuration: %1$s";
    }
    @Override
    public final SearchException unableToApplyQueryCacheConfiguration(final String errorMessage, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToApplyQueryCacheConfiguration$str(), errorMessage), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multiTenancyRequiredButExplicitlyDisabledByBackend$str() {
        return "HSEARCH600148: Invalid backend configuration: mapping requires multi-tenancy but no multi-tenancy strategy is set.";
    }
    @Override
    public final SearchException multiTenancyRequiredButExplicitlyDisabledByBackend() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multiTenancyRequiredButExplicitlyDisabledByBackend$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multiTenancyNotRequiredButExplicitlyEnabledByTheBackend$str() {
        return "HSEARCH600149: Invalid backend configuration: mapping requires single-tenancy but multi-tenancy strategy is set.";
    }
    @Override
    public final SearchException multiTenancyNotRequiredButExplicitlyEnabledByTheBackend() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multiTenancyNotRequiredButExplicitlyEnabledByTheBackend$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void luceneCompatibilityVersion(final Version luceneVersion) {
        super.log.logf(FQCN, DEBUG, null, luceneCompatibilityVersion$str(), luceneVersion);
    }
    protected String luceneCompatibilityVersion$str() {
        return "HSEARCH600188: Setting Lucene compatibility to Version %s";
    }
}
