package org.hibernate.search.backend.lucene.logging.impl;

import java.util.Locale;
import org.hibernate.search.util.common.reporting.EventContext;
import java.io.Serializable;
import org.hibernate.search.util.common.SearchException;
import java.lang.Class;
import java.lang.String;
import java.io.IOException;
import org.jboss.logging.Logger;
import java.util.Arrays;
import java.lang.Exception;


import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class AnalysisLog_$logger implements AnalysisLog, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = AnalysisLog_$logger.class.getName();
    public AnalysisLog_$logger(final Logger log) {
        this.log = log;
    }
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String unableToApplyAnalysisConfiguration$str() {
        return "HSEARCH000329: Unable to apply analysis configuration: %1$s";
    }
    @Override
    public final SearchException unableToApplyAnalysisConfiguration(final String errorMessage, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToApplyAnalysisConfiguration$str(), errorMessage), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String analysisComponentParameterConflict$str() {
        return "HSEARCH000337: Ambiguous value for parameter '%1$s': this parameter is set to two different values '%2$s' and '%3$s'.";
    }
    @Override
    public final SearchException analysisComponentParameterConflict(final String name, final String value1, final String value2) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), analysisComponentParameterConflict$str(), name, value1, value2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotApplyAnalyzerAndNormalizer$str() {
        return "HSEARCH000342: Invalid index field type: both analyzer '%1$s' and normalizer '%2$s' are assigned to this type. Either an analyzer or a normalizer can be assigned, but not both.";
    }
    @Override
    public final SearchException cannotApplyAnalyzerAndNormalizer(final String analyzerName, final String normalizerName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotApplyAnalyzerAndNormalizer$str(), analyzerName, normalizerName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void normalizerProducedMultipleTokens(final String normalizerName, final int token) {
        log.logf(FQCN, WARN, null, normalizerProducedMultipleTokens$str(), normalizerName, token);
    }
    protected String normalizerProducedMultipleTokens$str() {
        return "HSEARCH000344: Invalid normalizer implementation: the normalizer for definition '%s' produced %d tokens. Normalizers should never produce more than one token. The tokens have been concatenated by Hibernate Search, but you should fix your normalizer definition.";
    }
    protected String cannotUseAnalyzerOnSortableField$str() {
        return "HSEARCH000345: Invalid index field type: both analyzer '%1$s' and sorts are enabled. Sorts are not supported on analyzed fields. If you need an analyzer simply to transform the text (lowercasing, ...) without splitting it into tokens, use a normalizer instead. If you need an actual analyzer (with tokenization), define two separate fields: one with an analyzer that is not sortable, and one with a normalizer that is sortable.";
    }
    @Override
    public final SearchException cannotUseAnalyzerOnSortableField(final String analyzerName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotUseAnalyzerOnSortableField$str(), analyzerName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownAnalyzer$str() {
        return "HSEARCH000353: Unknown analyzer: '%1$s'. Make sure you defined this analyzer.";
    }
    @Override
    public final SearchException unknownAnalyzer(final String analyzerName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownAnalyzer$str(), analyzerName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToCreateAnalyzer$str() {
        return "HSEARCH600052: Unable to create analyzer for name '%1$s': %2$s";
    }
    @Override
    public final SearchException unableToCreateAnalyzer(final String name, final String causeMessage, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToCreateAnalyzer$str(), name, causeMessage), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToCreateNormalizer$str() {
        return "HSEARCH600053: Unable to create normalizer for name '%1$s': %2$s";
    }
    @Override
    public final SearchException unableToCreateNormalizer(final String name, final String causeMessage, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToCreateNormalizer$str(), name, causeMessage), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownNormalizer$str() {
        return "HSEARCH600054: Unknown normalizer: '%1$s'. Make sure you defined this normalizer.";
    }
    @Override
    public final SearchException unknownNormalizer(final String normalizerName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownNormalizer$str(), normalizerName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotUseIndexNullAsAndAnalyzer$str() {
        return "HSEARCH600073: Invalid index field type: both null token '%2$s' ('indexNullAs') and analyzer '%1$s' are assigned to this type. 'indexNullAs' is not supported on analyzed fields.";
    }
    @Override
    public final SearchException cannotUseIndexNullAsAndAnalyzer(final String analyzerName, final String indexNullAs, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotUseIndexNullAsAndAnalyzer$str(), analyzerName, indexNullAs), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotUseAnalyzerOnAggregableField$str() {
        return "HSEARCH600094: Invalid index field type: both analyzer '%1$s' and aggregations are enabled. Aggregations are not supported on analyzed fields. If you need an analyzer simply to transform the text (lowercasing, ...) without splitting it into tokens, use a normalizer instead. If you need an actual analyzer (with tokenization), define two separate fields: one with an analyzer that is not aggregable, and one with a normalizer that is aggregable.";
    }
    @Override
    public final SearchException cannotUseAnalyzerOnAggregableField(final String analyzerName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotUseAnalyzerOnAggregableField$str(), analyzerName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String searchAnalyzerWithoutAnalyzer$str() {
        return "HSEARCH600104: Invalid index field type: search analyzer '%1$s' is assigned to this type, but the indexing analyzer is missing. Assign an indexing analyzer and a search analyzer, or remove the search analyzer.";
    }
    @Override
    public final SearchException searchAnalyzerWithoutAnalyzer(final String searchAnalyzer, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), searchAnalyzerWithoutAnalyzer$str(), searchAnalyzer), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToCreateAnalysisComponent$str() {
        return "HSEARCH600142: Unable to create instance of analysis component '%1$s': %2$s";
    }
    @Override
    public final SearchException unableToCreateAnalysisComponent(final Class<?> type, final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToCreateAnalysisComponent$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(type), causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noSuchAnalyzer$str() {
        return "HSEARCH600181: An analyzer '%1$s' cannot be found.";
    }
    @Override
    public final SearchException noSuchAnalyzer(final String analyzer) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), noSuchAnalyzer$str(), analyzer));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noSuchNormalizer$str() {
        return "HSEARCH600182: A normalizer '%1$s' cannot be found.";
    }
    @Override
    public final SearchException noSuchNormalizer(final String normalizer) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), noSuchNormalizer$str(), normalizer));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToPerformAnalysisOperation$str() {
        return "HSEARCH600183: Failed to apply '%1$s' to '%2$s': '%3$s'";
    }
    @Override
    public final SearchException unableToPerformAnalysisOperation(final String analyzerName, final String string, final String reason, final IOException cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToPerformAnalysisOperation$str(), analyzerName, string, reason), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
}
