/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.predicate.impl;

import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.hibernate.search.backend.lucene.search.common.impl.AbstractLuceneValueFieldSearchQueryElementFactory;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexValueFieldContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneLeafSingleFieldPredicate;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.RegexpQueryFlag;
import org.hibernate.search.engine.search.predicate.spi.RegexpPredicateBuilder;

public class LuceneTextRegexpPredicate
extends AbstractLuceneLeafSingleFieldPredicate {
    private LuceneTextRegexpPredicate(Builder<?> builder) {
        super(builder);
    }

    private static int toFlagsMask(Set<RegexpQueryFlag> flags) {
        int flag = 0;
        if (flags == null || flags.isEmpty()) {
            return 0;
        }
        for (RegexpQueryFlag operation : flags) {
            switch (operation) {
                case INTERVAL: {
                    flag |= 0x20;
                    break;
                }
                case INTERSECTION: {
                    flag |= 1;
                    break;
                }
                case ANY_STRING: {
                    flag |= 8;
                }
            }
        }
        return flag;
    }

    private static class Builder<F>
    extends AbstractLuceneLeafSingleFieldPredicate.AbstractBuilder<F>
    implements RegexpPredicateBuilder {
        private String pattern;
        private int flags = 0;

        private Builder(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            super(scope, field);
        }

        public void pattern(String regexpPattern) {
            this.pattern = regexpPattern;
        }

        public void flags(Set<RegexpQueryFlag> flags) {
            this.flags = LuceneTextRegexpPredicate.toFlagsMask(flags);
        }

        public SearchPredicate build() {
            return new LuceneTextRegexpPredicate(this);
        }

        @Override
        protected Query buildQuery() {
            return new RegexpQuery(new Term(this.absoluteFieldPath, this.pattern), this.flags);
        }
    }

    public static class Factory<F>
    extends AbstractLuceneValueFieldSearchQueryElementFactory<RegexpPredicateBuilder, F> {
        @Override
        public Builder<F> create(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            return new Builder<F>(scope, field);
        }
    }
}

