/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneResult;
import org.hibernate.search.backend.lucene.search.projection.impl.AbstractLuceneProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionRequestContext;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.spi.ScoreProjectionBuilder;

class LuceneScoreProjection
extends AbstractLuceneProjection<Float, Float> {
    private LuceneScoreProjection(LuceneSearchIndexScope<?> scope) {
        super(scope);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void request(SearchProjectionRequestContext context) {
        context.requireScore();
    }

    @Override
    public Float extract(ProjectionHitMapper<?, ?> mapper, LuceneResult documentResult, SearchProjectionExtractContext context) {
        return Float.valueOf(documentResult.getScore());
    }

    @Override
    public Float transform(LoadingResult<?, ?> loadingResult, Float extractedData, SearchProjectionTransformContext context) {
        return extractedData;
    }

    public static class Builder
    extends AbstractLuceneProjection.AbstractBuilder<Float>
    implements ScoreProjectionBuilder {
        public Builder(LuceneSearchIndexScope<?> scope) {
            super(scope);
        }

        public SearchProjection<Float> build() {
            return new LuceneScoreProjection(this.scope);
        }
    }
}

