/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.document.Document;
import org.hibernate.search.backend.lucene.document.impl.LuceneDocumentContentImpl;
import org.hibernate.search.backend.lucene.document.impl.LuceneFlattenedObjectFieldBuilder;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexFieldReference;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexObjectFieldReference;
import org.hibernate.search.backend.lucene.document.impl.LuceneNestedObjectFieldBuilder;
import org.hibernate.search.backend.lucene.document.model.impl.AbstractLuceneIndexSchemaFieldNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexModel;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectFieldNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaValueFieldNode;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.backend.document.IndexFieldReference;
import org.hibernate.search.engine.backend.document.IndexObjectFieldReference;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldFilter;
import org.hibernate.search.engine.backend.document.spi.NoOpDocumentElement;
import org.hibernate.search.engine.backend.metamodel.IndexValueFieldTypeDescriptor;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

abstract class AbstractLuceneDocumentElementBuilder
implements DocumentElement {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    protected final LuceneIndexModel model;
    protected final LuceneIndexSchemaObjectNode schemaNode;
    protected final LuceneDocumentContentImpl documentContent;
    private List<LuceneFlattenedObjectFieldBuilder> flattenedObjectDocumentBuilders;
    private List<LuceneNestedObjectFieldBuilder> nestedObjectDocumentBuilders;

    AbstractLuceneDocumentElementBuilder(LuceneIndexModel model, LuceneIndexSchemaObjectNode schemaNode, LuceneDocumentContentImpl documentContent) {
        this.model = model;
        this.schemaNode = schemaNode;
        this.documentContent = documentContent;
    }

    public <F> void addValue(IndexFieldReference<F> fieldReference, F value) {
        LuceneIndexFieldReference luceneFieldReference = (LuceneIndexFieldReference)fieldReference;
        LuceneIndexSchemaValueFieldNode fieldSchemaNode = luceneFieldReference.getSchemaNode();
        this.addValue(fieldSchemaNode, value);
    }

    public DocumentElement addObject(IndexObjectFieldReference fieldReference) {
        LuceneIndexObjectFieldReference luceneFieldReference = (LuceneIndexObjectFieldReference)fieldReference;
        LuceneIndexSchemaObjectFieldNode fieldSchemaNode = luceneFieldReference.getSchemaNode();
        return this.addObject(fieldSchemaNode, false);
    }

    public void addNullObject(IndexObjectFieldReference fieldReference) {
        LuceneIndexObjectFieldReference luceneFieldReference = (LuceneIndexObjectFieldReference)fieldReference;
        LuceneIndexSchemaObjectFieldNode fieldSchemaNode = luceneFieldReference.getSchemaNode();
        this.addObject(fieldSchemaNode, true);
    }

    public void addValue(String relativeFieldName, Object value) {
        String absoluteFieldPath = this.schemaNode.absolutePath(relativeFieldName);
        AbstractLuceneIndexSchemaFieldNode node = this.model.fieldOrNull(absoluteFieldPath, IndexFieldFilter.ALL);
        if (node == null) {
            throw log.unknownFieldForIndexing(absoluteFieldPath, this.model.getEventContext());
        }
        this.addValueUnknownType((LuceneIndexSchemaValueFieldNode<?>)node.toValueField(), value);
    }

    public DocumentElement addObject(String relativeFieldName) {
        String absoluteFieldPath = this.schemaNode.absolutePath(relativeFieldName);
        AbstractLuceneIndexSchemaFieldNode fieldSchemaNode = this.model.fieldOrNull(absoluteFieldPath, IndexFieldFilter.ALL);
        if (fieldSchemaNode == null) {
            throw log.unknownFieldForIndexing(absoluteFieldPath, this.model.getEventContext());
        }
        return this.addObject(fieldSchemaNode.toObjectField(), false);
    }

    public void addNullObject(String relativeFieldName) {
        String absoluteFieldPath = this.schemaNode.absolutePath(relativeFieldName);
        AbstractLuceneIndexSchemaFieldNode fieldSchemaNode = this.model.fieldOrNull(absoluteFieldPath, IndexFieldFilter.ALL);
        if (fieldSchemaNode == null) {
            throw log.unknownFieldForIndexing(absoluteFieldPath, this.model.getEventContext());
        }
        this.addObject(fieldSchemaNode.toObjectField(), true);
    }

    void checkNoValueYetForSingleValued(String absoluteFieldPath) {
        this.documentContent.checkNoValueYetForSingleValued(absoluteFieldPath);
    }

    private void addNestedObjectDocumentBuilder(LuceneNestedObjectFieldBuilder nestedObjectDocumentBuilder) {
        if (this.nestedObjectDocumentBuilders == null) {
            this.nestedObjectDocumentBuilders = new ArrayList<LuceneNestedObjectFieldBuilder>();
        }
        this.nestedObjectDocumentBuilders.add(nestedObjectDocumentBuilder);
    }

    private void addFlattenedObjectDocumentBuilder(LuceneFlattenedObjectFieldBuilder flattenedObjectDocumentBuilder) {
        if (this.flattenedObjectDocumentBuilders == null) {
            this.flattenedObjectDocumentBuilders = new ArrayList<LuceneFlattenedObjectFieldBuilder>();
        }
        this.flattenedObjectDocumentBuilders.add(flattenedObjectDocumentBuilder);
    }

    private void checkTreeConsistency(LuceneIndexSchemaObjectNode expectedParentNode) {
        if (!Objects.equals(expectedParentNode, this.schemaNode)) {
            throw log.invalidFieldForDocumentElement(expectedParentNode.absolutePath(), this.schemaNode.absolutePath());
        }
    }

    void contribute(MultiTenancyStrategy multiTenancyStrategy, String tenantId, String routingKey, String rootId, List<Document> nestedDocuments) {
        if (this.flattenedObjectDocumentBuilders != null) {
            for (LuceneFlattenedObjectFieldBuilder flattenedObjectDocumentBuilder : this.flattenedObjectDocumentBuilders) {
                flattenedObjectDocumentBuilder.contribute(multiTenancyStrategy, tenantId, routingKey, rootId, nestedDocuments);
            }
        }
        if (this.nestedObjectDocumentBuilders != null) {
            for (LuceneNestedObjectFieldBuilder nestedObjectDocumentBuilder : this.nestedObjectDocumentBuilders) {
                nestedObjectDocumentBuilder.contribute(multiTenancyStrategy, tenantId, routingKey, rootId, nestedDocuments);
            }
        }
    }

    abstract void ensureDynamicValueDetectedByExistsPredicateOnObjectField();

    private <F> void addValue(LuceneIndexSchemaValueFieldNode<F> node, F value) {
        LuceneIndexSchemaObjectNode expectedParentNode = node.parent();
        this.checkTreeConsistency(expectedParentNode);
        IndexValueFieldTypeDescriptor type = node.type();
        String absolutePath = node.absolutePath();
        if (!node.multiValued()) {
            this.checkNoValueYetForSingleValued(absolutePath);
        }
        type.codec().addToDocument(this.documentContent, absolutePath, value);
        if (value != null && node.dynamic()) {
            this.ensureDynamicValueDetectedByExistsPredicateOnObjectField();
        }
    }

    private DocumentElement addObject(LuceneIndexSchemaObjectFieldNode node, boolean nullObject) {
        LuceneIndexSchemaObjectNode expectedParentNode = node.parent();
        this.checkTreeConsistency(expectedParentNode);
        String absolutePath = node.absolutePath();
        if (!node.multiValued()) {
            this.checkNoValueYetForSingleValued(absolutePath);
        }
        if (nullObject) {
            return NoOpDocumentElement.get();
        }
        switch (node.structure()) {
            case NESTED: {
                LuceneNestedObjectFieldBuilder nestedDocumentBuilder = new LuceneNestedObjectFieldBuilder(this.model, node, this);
                this.addNestedObjectDocumentBuilder(nestedDocumentBuilder);
                return nestedDocumentBuilder;
            }
        }
        LuceneFlattenedObjectFieldBuilder flattenedDocumentBuilder = new LuceneFlattenedObjectFieldBuilder(this.model, node, this, this.documentContent);
        this.addFlattenedObjectDocumentBuilder(flattenedDocumentBuilder);
        return flattenedDocumentBuilder;
    }

    private void addValueUnknownType(LuceneIndexSchemaValueFieldNode<?> node, Object value) {
        if (value == null) {
            this.addValue(node, null);
        } else {
            LuceneIndexSchemaValueFieldNode<?> typeCheckedNode = node.withValueType(value.getClass(), this.model.getEventContext());
            this.addValue(typeCheckedNode, value);
        }
    }
}

