/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.orm.tooling.maven;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.hibernate.bytecode.enhance.spi.DefaultEnhancementContext;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.Enhancer;
import org.hibernate.bytecode.enhance.spi.UnloadedClass;
import org.hibernate.bytecode.enhance.spi.UnloadedField;
import org.hibernate.bytecode.internal.BytecodeProviderInitiator;
import org.hibernate.bytecode.spi.BytecodeProvider;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="enhance", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class MavenEnhancePlugin
extends AbstractMojo {
    private List<File> sourceSet = new ArrayList<File>();
    @Component
    private BuildContext buildContext;
    @Parameter(property="base", defaultValue="${project.build.outputDirectory}")
    private String base;
    @Parameter(property="dir", defaultValue="${project.build.outputDirectory}")
    private String dir;
    @Parameter(property="classNames", defaultValue="")
    private String classNames;
    @Parameter(property="failOnError", defaultValue="true")
    private boolean failOnError = true;
    @Parameter(property="enableLazyInitialization", defaultValue="true")
    private boolean enableLazyInitialization;
    @Parameter(property="enableDirtyTracking", defaultValue="true")
    private boolean enableDirtyTracking;
    @Parameter(property="enableAssociationManagement", defaultValue="false")
    private boolean enableAssociationManagement;
    @Parameter(property="enableExtendedEnhancement", defaultValue="false")
    private boolean enableExtendedEnhancement;

    private boolean shouldApply() {
        return this.enableLazyInitialization || this.enableDirtyTracking || this.enableAssociationManagement || this.enableExtendedEnhancement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        if (!this.shouldApply()) {
            log.warn((CharSequence)"Skipping Hibernate bytecode enhancement plugin execution since no feature is enabled");
            return;
        }
        if (!this.dir.startsWith(this.base)) {
            throw new MojoExecutionException("The enhancement directory 'dir' (" + this.dir + ") is no subdirectory of 'base' (" + this.base + ")");
        }
        File root = new File(this.dir);
        if (!root.exists()) {
            log.info((CharSequence)("Skipping Hibernate enhancement plugin execution since there is no classes dir " + this.dir));
            return;
        }
        this.walkDir(root);
        if (this.sourceSet.isEmpty()) {
            log.info((CharSequence)("Skipping Hibernate enhancement plugin execution since there are no classes to enhance on " + this.dir));
            return;
        }
        List<Object> classesToEnhance = new ArrayList();
        if (this.classNames.length() >= 1) {
            classesToEnhance = Arrays.asList(this.classNames.split(","));
        }
        log.info((CharSequence)("Starting Hibernate enhancement for classes on " + this.dir));
        final ClassLoader classLoader = this.toClassLoader(Collections.singletonList(new File(this.base)));
        DefaultEnhancementContext enhancementContext = new DefaultEnhancementContext(){

            public ClassLoader getLoadingClassLoader() {
                return classLoader;
            }

            public boolean doBiDirectionalAssociationManagement(UnloadedField field) {
                return MavenEnhancePlugin.this.enableAssociationManagement;
            }

            public boolean doDirtyCheckingInline(UnloadedClass classDescriptor) {
                return MavenEnhancePlugin.this.enableDirtyTracking;
            }

            public boolean hasLazyLoadableAttributes(UnloadedClass classDescriptor) {
                return MavenEnhancePlugin.this.enableLazyInitialization;
            }

            public boolean isLazyLoadable(UnloadedField field) {
                return MavenEnhancePlugin.this.enableLazyInitialization;
            }

            public boolean doExtendedEnhancement(UnloadedClass classDescriptor) {
                return MavenEnhancePlugin.this.enableExtendedEnhancement;
            }
        };
        if (!this.enableLazyInitialization) {
            log.warn((CharSequence)"The 'enableLazyInitialization' configuration is deprecated and will be removed. Set the value to 'true' to get rid of this warning");
        }
        if (!this.enableDirtyTracking) {
            log.warn((CharSequence)"The 'enableDirtyTracking' configuration is deprecated and will be removed. Set the value to 'true' to get rid of this warning");
        }
        if (this.enableExtendedEnhancement) {
            log.warn((CharSequence)"Extended enhancement is enabled. Classes other than entities may be modified. You should consider access the entities using getter/setter methods and disable this property. Use at your own risk.");
        }
        BytecodeProvider bytecodeProvider = BytecodeProviderInitiator.buildDefaultBytecodeProvider();
        try {
            Enhancer enhancer = bytecodeProvider.getEnhancer((EnhancementContext)enhancementContext);
            for (File file : this.sourceSet) {
                this.discoverTypes(file, enhancer);
                if (!log.isDebugEnabled()) continue;
                log.debug((CharSequence)("Successfully discovered types for class [" + file + "]"));
            }
            for (File file : this.sourceSet) {
                byte[] enhancedBytecode;
                String className = this.determineClassName(root, file);
                if (classesToEnhance.size() != 0 && !classesToEnhance.contains(className) || (enhancedBytecode = this.doEnhancement(file, enhancer)) == null) continue;
                this.writeOutEnhancedClass(enhancedBytecode, file);
                if (!log.isDebugEnabled()) continue;
                log.debug((CharSequence)("Successfully enhanced class [" + file + "]"));
            }
        }
        finally {
            bytecodeProvider.resetCaches();
        }
    }

    private ClassLoader toClassLoader(List<File> runtimeClasspath) throws MojoExecutionException {
        ArrayList<URL> urls = new ArrayList<URL>(runtimeClasspath.size());
        Log log = this.getLog();
        for (File file : runtimeClasspath) {
            try {
                urls.add(file.toURI().toURL());
                if (!log.isDebugEnabled()) continue;
                log.debug((CharSequence)("Adding classpath entry for classes root " + file.getAbsolutePath()));
            }
            catch (MalformedURLException e) {
                String msg = "Unable to resolve classpath entry to URL: " + file.getAbsolutePath();
                if (this.failOnError) {
                    throw new MojoExecutionException(msg, (Exception)e);
                }
                log.warn((CharSequence)msg);
            }
        }
        MavenProject project = (MavenProject)this.getPluginContext().get("project");
        Set artifacts = project.getArtifacts();
        if (artifacts != null) {
            for (Artifact a : artifacts) {
                if ("test".equals(a.getScope())) continue;
                try {
                    urls.add(a.getFile().toURI().toURL());
                    log.debug((CharSequence)("Adding classpath entry for dependency " + a.getId()));
                }
                catch (MalformedURLException e) {
                    String msg = "Unable to resolve URL for dependency " + a.getId() + " at " + a.getFile().getAbsolutePath();
                    if (this.failOnError) {
                        throw new MojoExecutionException(msg, (Exception)e);
                    }
                    log.warn((CharSequence)msg);
                }
            }
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), Enhancer.class.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] doEnhancement(File javaClassFile, Enhancer enhancer) throws MojoExecutionException {
        try {
            String className = javaClassFile.getAbsolutePath().substring(this.base.length() + 1, javaClassFile.getAbsolutePath().length() - ".class".length()).replace(File.separatorChar, '.');
            ByteArrayOutputStream originalBytes = new ByteArrayOutputStream();
            try (FileInputStream fileInputStream = new FileInputStream(javaClassFile);){
                int length;
                byte[] buffer = new byte[1024];
                while ((length = fileInputStream.read(buffer)) != -1) {
                    originalBytes.write(buffer, 0, length);
                }
            }
            return enhancer.enhance(className, originalBytes.toByteArray());
        }
        catch (Exception e) {
            String msg = "Unable to enhance class: " + javaClassFile.getName();
            if (this.failOnError) {
                throw new MojoExecutionException(msg, e);
            }
            this.buildContext.addMessage(javaClassFile, 0, 0, msg, 1, (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverTypes(File javaClassFile, Enhancer enhancer) throws MojoExecutionException {
        try {
            String className = javaClassFile.getAbsolutePath().substring(this.base.length() + 1, javaClassFile.getAbsolutePath().length() - ".class".length()).replace(File.separatorChar, '.');
            ByteArrayOutputStream originalBytes = new ByteArrayOutputStream();
            try (FileInputStream fileInputStream = new FileInputStream(javaClassFile);){
                int length;
                byte[] buffer = new byte[1024];
                while ((length = fileInputStream.read(buffer)) != -1) {
                    originalBytes.write(buffer, 0, length);
                }
            }
            enhancer.discoverTypes(className, originalBytes.toByteArray());
        }
        catch (Exception e) {
            String msg = "Unable to discover types for class: " + javaClassFile.getName();
            if (this.failOnError) {
                throw new MojoExecutionException(msg, e);
            }
            this.buildContext.addMessage(javaClassFile, 0, 0, msg, 1, (Throwable)e);
        }
    }

    private void walkDir(File dir) {
        this.walkDir(dir, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(".class");
            }
        }, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
    }

    private void walkDir(File dir, FileFilter classesFilter, FileFilter dirFilter) {
        File[] dirs;
        for (File dir1 : dirs = dir.listFiles(dirFilter)) {
            this.walkDir(dir1, classesFilter, dirFilter);
        }
        File[] files = dir.listFiles(classesFilter);
        Collections.addAll(this.sourceSet, files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOutEnhancedClass(byte[] enhancedBytecode, File file) throws MojoExecutionException {
        try {
            if (file.delete()) {
                if (!file.createNewFile()) {
                    this.buildContext.addMessage(file, 0, 0, "Unable to recreate class file", 2, null);
                }
            } else {
                this.buildContext.addMessage(file, 0, 0, "Unable to delete class file", 2, null);
            }
        }
        catch (IOException e) {
            this.buildContext.addMessage(file, 0, 0, "Problem preparing class file for writing out enhancements", 1, (Throwable)e);
        }
        OutputStream outputStream = null;
        try {
            outputStream = this.buildContext.newFileOutputStream(file);
            outputStream.write(enhancedBytecode);
            outputStream.flush();
        }
        catch (IOException e) {
            String msg = String.format("Error writing to enhanced class [%s] to file [%s]", file.getName(), file.getAbsolutePath());
            if (this.failOnError) {
                throw new MojoExecutionException(msg, (Exception)e);
            }
            this.buildContext.addMessage(file, 0, 0, msg, 1, (Throwable)e);
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private String determineClassName(File root, File javaClassFile) {
        Path relativeClassPath = root.toPath().relativize(javaClassFile.toPath());
        String relativeClassPathString = relativeClassPath.toString();
        String classNameBase = relativeClassPathString.substring(0, relativeClassPathString.length() - ".class".length());
        return classNameBase.replace(File.separatorChar, '.');
    }
}

