/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.orm.tooling.maven;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.hibernate.bytecode.enhance.spi.DefaultEnhancementContext;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.Enhancer;
import org.hibernate.bytecode.enhance.spi.UnloadedClass;
import org.hibernate.bytecode.enhance.spi.UnloadedField;
import org.hibernate.cfg.Environment;

@Mojo(name="enhance", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
@Execute(goal="enhance", phase=LifecyclePhase.COMPILE)
public class MavenEnhancePlugin
extends AbstractMojo {
    private List<File> sourceSet = new ArrayList<File>();
    @Parameter(property="dir", defaultValue="${project.build.outputDirectory}")
    private String dir;
    @Parameter(property="failOnError", defaultValue="true")
    private boolean failOnError = true;
    @Parameter(property="enableLazyInitialization", defaultValue="false")
    private boolean enableLazyInitialization;
    @Parameter(property="enableDirtyTracking", defaultValue="false")
    private boolean enableDirtyTracking;
    @Parameter(property="enableAssociationManagement", defaultValue="false")
    private boolean enableAssociationManagement;
    @Parameter(property="enableExtendedEnhancement", defaultValue="false")
    private boolean enableExtendedEnhancement;

    private boolean shouldApply() {
        return this.enableLazyInitialization || this.enableDirtyTracking || this.enableAssociationManagement || this.enableExtendedEnhancement;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.shouldApply()) {
            this.getLog().warn((CharSequence)"Skipping Hibernate bytecode enhancement plugin execution since no feature is enabled");
            return;
        }
        File root = new File(this.dir);
        if (!root.exists()) {
            this.getLog().info((CharSequence)("Skipping Hibernate enhancement plugin execution since there is no classes dir " + this.dir));
            return;
        }
        this.walkDir(root);
        if (this.sourceSet.isEmpty()) {
            this.getLog().info((CharSequence)("Skipping Hibernate enhancement plugin execution since there are no classes to enhance on " + this.dir));
            return;
        }
        this.getLog().info((CharSequence)("Starting Hibernate enhancement for classes on " + this.dir));
        final ClassLoader classLoader = this.toClassLoader(Collections.singletonList(root));
        DefaultEnhancementContext enhancementContext = new DefaultEnhancementContext(){

            public ClassLoader getLoadingClassLoader() {
                return classLoader;
            }

            public boolean doBiDirectionalAssociationManagement(UnloadedField field) {
                return MavenEnhancePlugin.this.enableAssociationManagement;
            }

            public boolean doDirtyCheckingInline(UnloadedClass classDescriptor) {
                return MavenEnhancePlugin.this.enableDirtyTracking;
            }

            public boolean hasLazyLoadableAttributes(UnloadedClass classDescriptor) {
                return MavenEnhancePlugin.this.enableLazyInitialization;
            }

            public boolean isLazyLoadable(UnloadedField field) {
                return MavenEnhancePlugin.this.enableLazyInitialization;
            }

            public boolean doExtendedEnhancement(UnloadedClass classDescriptor) {
                return MavenEnhancePlugin.this.enableExtendedEnhancement;
            }
        };
        if (this.enableExtendedEnhancement) {
            this.getLog().warn((CharSequence)"Extended enhancement is enabled. Classes other than entities may be modified. You should consider access the entities using getter/setter methods and disable this property. Use at your own risk.");
        }
        Enhancer enhancer = Environment.getBytecodeProvider().getEnhancer((EnhancementContext)enhancementContext);
        for (File file : this.sourceSet) {
            byte[] enhancedBytecode = this.doEnhancement(file, enhancer);
            if (enhancedBytecode == null) continue;
            this.writeOutEnhancedClass(enhancedBytecode, file);
            this.getLog().info((CharSequence)("Successfully enhanced class [" + file + "]"));
        }
    }

    private ClassLoader toClassLoader(List<File> runtimeClasspath) throws MojoExecutionException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File file : runtimeClasspath) {
            try {
                urls.add(file.toURI().toURL());
                this.getLog().debug((CharSequence)("Adding classpath entry for classes root " + file.getAbsolutePath()));
            }
            catch (MalformedURLException e) {
                String msg = "Unable to resolve classpath entry to URL: " + file.getAbsolutePath();
                if (this.failOnError) {
                    throw new MojoExecutionException(msg, (Exception)e);
                }
                this.getLog().warn((CharSequence)msg);
            }
        }
        Set artifacts = null;
        MavenProject project = (MavenProject)this.getPluginContext().get("project");
        if (project != null) {
            MavenProject executionProject = project.getExecutionProject();
            Set set = artifacts = executionProject != null ? executionProject.getArtifacts() : project.getArtifacts();
        }
        if (artifacts != null) {
            for (Artifact a : artifacts) {
                if ("test".equals(a.getScope())) continue;
                try {
                    urls.add(a.getFile().toURI().toURL());
                    this.getLog().debug((CharSequence)("Adding classpath entry for dependency " + a.getId()));
                }
                catch (MalformedURLException e) {
                    String msg = "Unable to resolve URL for dependency " + a.getId() + " at " + a.getFile().getAbsolutePath();
                    if (this.failOnError) {
                        throw new MojoExecutionException(msg, (Exception)e);
                    }
                    this.getLog().warn((CharSequence)msg);
                }
            }
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), Enhancer.class.getClassLoader());
    }

    private byte[] doEnhancement(File javaClassFile, Enhancer enhancer) throws MojoExecutionException {
        try {
            return enhancer.enhance(javaClassFile);
        }
        catch (Exception e) {
            String msg = "Unable to enhance class: " + javaClassFile.getName();
            if (this.failOnError) {
                throw new MojoExecutionException(msg, e);
            }
            this.getLog().warn((CharSequence)msg);
            return null;
        }
    }

    private void walkDir(File dir) {
        this.walkDir(dir, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(".class");
            }
        }, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
    }

    private void walkDir(File dir, FileFilter classesFilter, FileFilter dirFilter) {
        File[] dirs;
        for (File dir1 : dirs = dir.listFiles(dirFilter)) {
            this.walkDir(dir1, classesFilter, dirFilter);
        }
        File[] files = dir.listFiles(classesFilter);
        Collections.addAll(this.sourceSet, files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOutEnhancedClass(byte[] enhancedBytecode, File file) throws MojoExecutionException {
        try {
            if (file.delete()) {
                if (!file.createNewFile()) {
                    this.getLog().error((CharSequence)("Unable to recreate class file [" + file.getName() + "]"));
                }
            } else {
                this.getLog().error((CharSequence)("Unable to delete class file [" + file.getName() + "]"));
            }
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Problem preparing class file for writing out enhancements [" + file.getName() + "]"));
        }
        try {
            FileOutputStream outputStream = new FileOutputStream(file, false);
            try {
                outputStream.write(enhancedBytecode);
                outputStream.flush();
            }
            catch (IOException e) {
                String msg = String.format("Error writing to enhanced class [%s] to file [%s]", file.getName(), file.getAbsolutePath());
                if (this.failOnError) {
                    throw new MojoExecutionException(msg, (Exception)e);
                }
                this.getLog().warn((CharSequence)msg);
            }
            finally {
                try {
                    outputStream.close();
                }
                catch (IOException e) {}
            }
        }
        catch (FileNotFoundException e) {
            String msg = "Error opening class file for writing: " + file.getAbsolutePath();
            if (this.failOnError) {
                throw new MojoExecutionException(msg, (Exception)e);
            }
            this.getLog().warn((CharSequence)msg);
        }
    }
}

