/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.orm.tooling.maven;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.hibernate.bytecode.enhance.spi.DefaultEnhancementContext;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.Enhancer;

@Mojo(name="enhance", defaultPhase=LifecyclePhase.COMPILE)
@Execute(goal="enhance", phase=LifecyclePhase.COMPILE)
public class MavenEnhancePlugin
extends AbstractMojo {
    private List<File> sourceSet = new ArrayList<File>();
    @Parameter(property="dir", defaultValue="${project.build.outputDirectory}")
    private String dir = null;
    @Parameter(property="failOnError", defaultValue="true")
    private boolean failOnError = true;
    @Parameter(property="enableLazyInitialization", defaultValue="true")
    private boolean enableLazyInitialization = true;
    @Parameter(property="enableDirtyTracking", defaultValue="true")
    private boolean enableDirtyTracking = true;
    @Parameter(property="enableAssociationManagement", defaultValue="true")
    private boolean enableAssociationManagement = true;

    private boolean shouldApply() {
        return this.enableLazyInitialization || this.enableDirtyTracking || this.enableAssociationManagement;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.shouldApply()) {
            return;
        }
        this.getLog().info((CharSequence)("Starting Hibernate enhancement for class sourceSet on " + this.dir));
        File root = new File(this.dir);
        this.walkDir(root);
        final ClassLoader classLoader = this.toClassLoader(Arrays.asList(root));
        DefaultEnhancementContext enhancementContext = new DefaultEnhancementContext(){

            public ClassLoader getLoadingClassLoader() {
                return classLoader;
            }

            public boolean doBiDirectionalAssociationManagement(CtField field) {
                return MavenEnhancePlugin.this.enableAssociationManagement;
            }

            public boolean doDirtyCheckingInline(CtClass classDescriptor) {
                return MavenEnhancePlugin.this.enableDirtyTracking;
            }

            public boolean hasLazyLoadableAttributes(CtClass classDescriptor) {
                return MavenEnhancePlugin.this.enableLazyInitialization;
            }

            public boolean isLazyLoadable(CtField field) {
                return MavenEnhancePlugin.this.enableLazyInitialization;
            }
        };
        Enhancer enhancer = new Enhancer((EnhancementContext)enhancementContext);
        ClassPool classPool = new ClassPool(false);
        for (File file : this.sourceSet) {
            CtClass ctClass = this.toCtClass(file, classPool);
            if (ctClass == null) continue;
            if (!enhancementContext.isEntityClass(ctClass) && !enhancementContext.isCompositeClass(ctClass)) {
                this.getLog().info((CharSequence)("Skipping class file [" + file.getAbsolutePath() + "], not an entity nor embeddable"));
                continue;
            }
            byte[] enhancedBytecode = this.doEnhancement(ctClass, enhancer);
            this.writeOutEnhancedClass(enhancedBytecode, ctClass, file);
            this.getLog().info((CharSequence)("Successfully enhanced class [" + ctClass.getName() + "]"));
        }
    }

    private ClassLoader toClassLoader(List<File> runtimeClasspath) throws MojoExecutionException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File file : runtimeClasspath) {
            try {
                urls.add(file.toURI().toURL());
                this.getLog().debug((CharSequence)("Adding root " + file.getAbsolutePath() + " to classpath "));
            }
            catch (MalformedURLException e) {
                String msg = "Unable to resolve classpath entry to URL: " + file.getAbsolutePath();
                if (this.failOnError) {
                    throw new MojoExecutionException(msg, (Exception)e);
                }
                this.getLog().warn((CharSequence)msg);
            }
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), Enhancer.class.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CtClass toCtClass(File file, ClassPool classPool) throws MojoExecutionException {
        try {
            FileInputStream is = new FileInputStream(file.getAbsolutePath());
            try {
                CtClass ctClass = classPool.makeClass((InputStream)is);
                return ctClass;
            }
            catch (IOException e) {
                String msg = "Javassist unable to load class in preparation for enhancing: " + file.getAbsolutePath();
                if (this.failOnError) {
                    throw new MojoExecutionException(msg, (Exception)e);
                }
                this.getLog().warn((CharSequence)msg);
                CtClass ctClass2 = null;
                return ctClass2;
            }
            finally {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e4) {
                    this.getLog().info((CharSequence)("Was unable to close InputStream : " + file.getAbsolutePath()), (Throwable)e4);
                }
            }
        }
        catch (FileNotFoundException e3) {
            String msg = "Unable to locate class file for InputStream: " + file.getAbsolutePath();
            if (this.failOnError) {
                throw new MojoExecutionException(msg, (Exception)e3);
            }
            this.getLog().warn((CharSequence)msg);
            return null;
        }
    }

    private byte[] doEnhancement(CtClass ctClass, Enhancer enhancer) throws MojoExecutionException {
        try {
            return enhancer.enhance(ctClass.getName(), ctClass.toBytecode());
        }
        catch (Exception e) {
            String msg = "Unable to enhance class: " + ctClass.getName();
            if (this.failOnError) {
                throw new MojoExecutionException(msg, e);
            }
            this.getLog().warn((CharSequence)msg);
            return null;
        }
    }

    private void walkDir(File dir) {
        this.walkDir(dir, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(".class");
            }
        }, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
    }

    private void walkDir(File dir, FileFilter classesFilter, FileFilter dirFilter) {
        File[] dirs;
        for (File dir1 : dirs = dir.listFiles(dirFilter)) {
            this.walkDir(dir1, classesFilter, dirFilter);
        }
        File[] files = dir.listFiles(classesFilter);
        Collections.addAll(this.sourceSet, files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOutEnhancedClass(byte[] enhancedBytecode, CtClass ctClass, File file) throws MojoExecutionException {
        if (enhancedBytecode == null) {
            return;
        }
        try {
            if (file.delete()) {
                if (!file.createNewFile()) {
                    this.getLog().error((CharSequence)("Unable to recreate class file [" + ctClass.getName() + "]"));
                }
            } else {
                this.getLog().error((CharSequence)("Unable to delete class file [" + ctClass.getName() + "]"));
            }
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Problem preparing class file for writing out enhancements [" + ctClass.getName() + "]"));
        }
        try {
            FileOutputStream outputStream = new FileOutputStream(file, false);
            try {
                outputStream.write(enhancedBytecode);
                outputStream.flush();
            }
            catch (IOException e) {
                String msg = String.format("Error writing to enhanced class [%s] to file [%s]", ctClass.getName(), file.getAbsolutePath());
                if (this.failOnError) {
                    throw new MojoExecutionException(msg, (Exception)e);
                }
                this.getLog().warn((CharSequence)msg);
            }
            finally {
                try {
                    outputStream.close();
                    ctClass.detach();
                }
                catch (IOException e) {}
            }
        }
        catch (FileNotFoundException e) {
            String msg = "Error opening class file for writing: " + file.getAbsolutePath();
            if (this.failOnError) {
                throw new MojoExecutionException(msg, (Exception)e);
            }
            this.getLog().warn((CharSequence)msg);
        }
    }
}

