/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.orm.tooling.maven;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.hibernate.bytecode.enhance.spi.DefaultEnhancementContext;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.Enhancer;

@Mojo(name="enhance", defaultPhase=LifecyclePhase.COMPILE)
@Execute(goal="enhance", phase=LifecyclePhase.COMPILE)
public class MavenEnhancePlugin
extends AbstractMojo {
    private List<File> sourceSet = new ArrayList<File>();
    @Parameter(property="dir", defaultValue="${project.build.outputDirectory}")
    private String dir = null;
    @Parameter(property="enableLazyInitialization", defaultValue="true")
    private boolean enableLazyInitialization = true;
    @Parameter(property="enableDirtyTracking", defaultValue="true")
    private boolean enableDirtyTracking = true;
    @Parameter(property="enableAssociationManagement", defaultValue="true")
    private boolean enableAssociationManagement = true;

    private boolean shouldApply() {
        return this.enableLazyInitialization || this.enableDirtyTracking || this.enableAssociationManagement;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.shouldApply()) {
            return;
        }
        this.getLog().info((CharSequence)("Starting Hibernate enhancement for class sourceSet on " + this.dir));
        File root = new File(this.dir);
        this.walkDir(root);
        final ClassLoader classLoader = this.toClassLoader(this.sourceSet);
        DefaultEnhancementContext enhancementContext = new DefaultEnhancementContext(){

            public ClassLoader getLoadingClassLoader() {
                return classLoader;
            }

            public boolean doBiDirectionalAssociationManagement(CtField field) {
                return MavenEnhancePlugin.this.enableAssociationManagement;
            }

            public boolean doDirtyCheckingInline(CtClass classDescriptor) {
                return MavenEnhancePlugin.this.enableDirtyTracking;
            }

            public boolean hasLazyLoadableAttributes(CtClass classDescriptor) {
                return MavenEnhancePlugin.this.enableLazyInitialization;
            }

            public boolean isLazyLoadable(CtField field) {
                return true;
            }
        };
        Enhancer enhancer = new Enhancer((EnhancementContext)enhancementContext);
        ClassPool classPool = new ClassPool(false);
        for (File file : this.sourceSet) {
            CtClass ctClass = this.toCtClass(file, classPool);
            if (!ctClass.hasAnnotation(Entity.class) && !ctClass.hasAnnotation(Embedded.class)) {
                this.getLog().debug((CharSequence)("Skipping class file [" + file.getAbsolutePath() + "], not an entity nor embedded"));
                continue;
            }
            byte[] enhancedBytecode = this.doEnhancement(ctClass, enhancer);
            this.writeOutEnhancedClass(enhancedBytecode, ctClass, file);
        }
    }

    private ClassLoader toClassLoader(List<File> runtimeClasspath) throws MojoExecutionException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File file : runtimeClasspath) {
            try {
                urls.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Unable to resolve classpath entry to URL : " + file.getAbsolutePath(), (Exception)e);
            }
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), Enhancer.class.getClassLoader());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CtClass toCtClass(File file, ClassPool classPool) throws MojoExecutionException {
        try {
            FileInputStream is = new FileInputStream(file.getAbsolutePath());
            try {
                CtClass ctClass = classPool.makeClass((InputStream)is);
                return ctClass;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Javassist unable to load class in preparation for enhancing : " + file.getAbsolutePath(), (Exception)e);
            }
            finally {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    this.getLog().info((CharSequence)("Was unable to close InputStream : " + file.getAbsolutePath()), (Throwable)e);
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Unable to locate class file for InputStream: " + file.getAbsolutePath(), (Exception)e);
        }
    }

    private byte[] doEnhancement(CtClass ctClass, Enhancer enhancer) throws MojoExecutionException {
        try {
            return enhancer.enhance(ctClass.getName(), ctClass.toBytecode());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to enhance class : " + ctClass.getName(), e);
        }
    }

    private void walkDir(File dir) {
        this.walkDir(dir, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(".class");
            }
        }, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
    }

    private void walkDir(File dir, FileFilter classesFilter, FileFilter dirFilter) {
        File[] dirs;
        for (File dir1 : dirs = dir.listFiles(dirFilter)) {
            this.walkDir(dir1, classesFilter, dirFilter);
        }
        File[] files = dir.listFiles(classesFilter);
        Collections.addAll(this.sourceSet, files);
    }

    private void writeOutEnhancedClass(byte[] enhancedBytecode, CtClass ctClass, File file) throws MojoExecutionException {
        try {
            if (file.delete()) {
                if (!file.createNewFile()) {
                    this.getLog().error((CharSequence)("Unable to recreate class file [" + ctClass.getName() + "]"));
                }
            } else {
                this.getLog().error((CharSequence)("Unable to delete class file [" + ctClass.getName() + "]"));
            }
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Problem preparing class file for writing out enhancements [" + ctClass.getName() + "]"));
        }
        try {
            FileOutputStream outputStream = new FileOutputStream(file, false);
            try {
                outputStream.write(enhancedBytecode);
                outputStream.flush();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error writing to enhanced class [" + ctClass.getName() + "] to file [" + file.getAbsolutePath() + "]", (Exception)e);
            }
            finally {
                try {
                    outputStream.close();
                    ctClass.detach();
                }
                catch (IOException iOException) {}
            }
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Error opening class file for writing : " + file.getAbsolutePath(), (Exception)e);
        }
    }
}

