/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.plugins;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javax.persistence.ElementCollection;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.Enhancer;

@Mojo(name="enhance", defaultPhase=LifecyclePhase.COMPILE)
@Execute(goal="enhance", phase=LifecyclePhase.COMPILE)
public class MavenEnhancePlugin
extends AbstractMojo
implements EnhancementContext {
    private List<File> classes = new ArrayList<File>();
    private ClassPool pool = new ClassPool(false);
    private final Enhancer enhancer = new Enhancer((EnhancementContext)this);
    private static final String CLASS_EXTENSION = ".class";
    @Parameter(property="dir", defaultValue="${project.build.outputDirectory}")
    private String dir = null;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Started enhance plugin.....");
        File root = new File(this.dir);
        this.walkDir(root);
        if (0 < this.classes.size()) {
            for (File file : this.classes) {
                this.processClassFile(file);
            }
        }
        this.getLog().info((CharSequence)"Enhance plugin completed.");
    }

    private void walkDir(File dir) {
        this.walkDir(dir, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(MavenEnhancePlugin.CLASS_EXTENSION);
            }
        }, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
    }

    private void walkDir(File dir, FileFilter classesFilter, FileFilter dirFilter) {
        File[] dirs = dir.listFiles(dirFilter);
        for (int i = 0; i < dirs.length; ++i) {
            this.walkDir(dirs[i], classesFilter, dirFilter);
        }
        dirs = null;
        File[] files = dir.listFiles(classesFilter);
        for (int i = 0; i < files.length; ++i) {
            this.classes.add(files[i]);
        }
    }

    private void processClassFile(File javaClassFile) throws MojoExecutionException {
        try {
            CtClass ctClass = this.getClassPool().makeClass((InputStream)new FileInputStream(javaClassFile));
            if (this.isEntityClass(ctClass)) {
                this.processEntityClassFile(javaClassFile, ctClass);
            } else if (this.isCompositeClass(ctClass)) {
                this.processCompositeClassFile(javaClassFile, ctClass);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Error processing included file [%s]", javaClassFile.getAbsolutePath()), (Exception)e);
        }
    }

    private void processEntityClassFile(File javaClassFile, CtClass ctClass) {
        try {
            this.getLog().info((CharSequence)String.format("Processing Entity class file [%1$s].", ctClass.getName()));
            byte[] result = this.enhancer.enhance(ctClass.getName(), ctClass.toBytecode());
            if (result != null) {
                this.writeEnhancedClass(javaClassFile, result);
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Unable to enhance class [" + ctClass.getName() + "]"), (Throwable)e);
            return;
        }
    }

    private void processCompositeClassFile(File javaClassFile, CtClass ctClass) {
        try {
            this.getLog().info((CharSequence)String.format("Processing Composite class file [%1$s].", ctClass.getName()));
            byte[] result = this.enhancer.enhanceComposite(ctClass.getName(), ctClass.toBytecode());
            if (result != null) {
                this.writeEnhancedClass(javaClassFile, result);
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Unable to enhance class [" + ctClass.getName() + "]"), (Throwable)e);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeEnhancedClass(File javaClassFile, byte[] result) throws MojoExecutionException {
        try {
            if (javaClassFile.delete()) {
                if (!javaClassFile.createNewFile()) {
                    this.getLog().error((CharSequence)("Unable to recreate class file [" + javaClassFile.getName() + "]"));
                }
            } else {
                this.getLog().error((CharSequence)("Unable to delete class file [" + javaClassFile.getName() + "]"));
            }
            FileOutputStream outputStream = new FileOutputStream(javaClassFile, false);
            try {
                outputStream.write(result);
                outputStream.flush();
            }
            finally {
                try {
                    outputStream.close();
                }
                catch (IOException ignore) {}
            }
        }
        catch (FileNotFoundException ignore) {
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Error processing included file [%s]", javaClassFile.getAbsolutePath()), (Exception)e);
        }
    }

    private ClassPool getClassPool() {
        return this.pool;
    }

    private boolean shouldInclude(CtClass ctClass) {
        return ctClass.hasAnnotation(Entity.class);
    }

    public ClassLoader getLoadingClassLoader() {
        return ((Object)((Object)this)).getClass().getClassLoader();
    }

    public boolean isEntityClass(CtClass classDescriptor) {
        return classDescriptor.hasAnnotation(Entity.class);
    }

    public boolean isCompositeClass(CtClass classDescriptor) {
        return classDescriptor.hasAnnotation(Embeddable.class);
    }

    public boolean doDirtyCheckingInline(CtClass classDescriptor) {
        return true;
    }

    public boolean hasLazyLoadableAttributes(CtClass classDescriptor) {
        return true;
    }

    public boolean isLazyLoadable(CtField field) {
        return true;
    }

    public boolean isPersistentField(CtField ctField) {
        return !ctField.hasAnnotation(Transient.class);
    }

    public boolean isMappedCollection(CtField field) {
        try {
            return field.getAnnotation(OneToMany.class) != null || field.getAnnotation(ManyToMany.class) != null || field.getAnnotation(ElementCollection.class) != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public CtField[] order(CtField[] persistentFields) {
        return persistentFields;
    }
}

