/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector.internal;

import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.query.sqm.produce.function.FunctionArgumentTypeResolver;
import org.hibernate.query.sqm.produce.function.internal.AbstractFunctionArgumentTypeResolver;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.type.StandardBasicTypes;

public class VectorArgumentTypeResolver
implements AbstractFunctionArgumentTypeResolver {
    public static final FunctionArgumentTypeResolver INSTANCE = new VectorArgumentTypeResolver(0);
    public static final FunctionArgumentTypeResolver DISTANCE_INSTANCE = new VectorArgumentTypeResolver(0, 1);
    private final int[] vectorIndices;

    public VectorArgumentTypeResolver(int ... vectorIndices) {
        this.vectorIndices = vectorIndices;
    }

    public @Nullable MappingModelExpressible<?> resolveFunctionArgumentType(List<? extends SqmTypedNode<?>> arguments, int argumentIndex, SqmToSqlAstConverter converter) {
        for (int i : this.vectorIndices) {
            MappingModelExpressible expressible;
            SqmTypedNode<?> node;
            if (i == argumentIndex || !((node = arguments.get(i)) instanceof SqmExpression) || (expressible = converter.determineValueMapping((SqmExpression)node)) == null) continue;
            return expressible;
        }
        return converter.getCreationContext().getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.VECTOR);
    }
}

