/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector.internal;

import java.util.Arrays;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.tool.schema.extract.spi.ColumnTypeInformation;
import org.hibernate.type.BasicCollectionType;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.java.BasicPluralJavaType;
import org.hibernate.type.descriptor.java.FloatJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.MutableMutabilityPlan;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.vector.SparseFloatVector;

public class SparseFloatVectorJavaType
extends AbstractClassJavaType<SparseFloatVector>
implements BasicPluralJavaType<Float> {
    public static final SparseFloatVectorJavaType INSTANCE = new SparseFloatVectorJavaType();

    public SparseFloatVectorJavaType() {
        super(SparseFloatVector.class, (MutabilityPlan)new SparseVectorMutabilityPlan());
    }

    public JavaType<Float> getElementJavaType() {
        return FloatJavaType.INSTANCE;
    }

    public BasicType<?> resolveType(TypeConfiguration typeConfiguration, Dialect dialect, BasicType<Float> elementType, ColumnTypeInformation columnTypeInformation, JdbcTypeIndicators stdIndicators) {
        int arrayTypeCode = stdIndicators.getPreferredSqlTypeCodeForArray(elementType.getJdbcType().getDefaultSqlTypeCode());
        JdbcType arrayJdbcType = typeConfiguration.getJdbcTypeRegistry().resolveTypeConstructorDescriptor(arrayTypeCode, elementType, columnTypeInformation);
        if (elementType.getValueConverter() != null) {
            throw new IllegalArgumentException("Can't convert element type of sparse vector");
        }
        return typeConfiguration.getBasicTypeRegistry().resolve((JavaType)this, arrayJdbcType, () -> new BasicCollectionType(elementType, arrayJdbcType, (JavaType)this, "sparse_float_vector"));
    }

    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators indicators) {
        return indicators.getJdbcType(10006);
    }

    public <X> X unwrap(SparseFloatVector value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (type.isInstance(value)) {
            return (X)value;
        }
        if (float[].class.isAssignableFrom(type)) {
            return (X)value.toDenseVector();
        }
        if (Object[].class.isAssignableFrom(type)) {
            return (X)value.toArray();
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)value.toString();
        }
        throw this.unknownUnwrap(type);
    }

    public <X> SparseFloatVector wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof SparseFloatVector) {
            SparseFloatVector vector = (SparseFloatVector)value;
            return vector;
        }
        if (value instanceof List) {
            List list = (List)value;
            return new SparseFloatVector(list);
        }
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            return new SparseFloatVector(Arrays.asList(array));
        }
        if (value instanceof float[]) {
            float[] vector = (float[])value;
            return new SparseFloatVector(vector);
        }
        if (value instanceof String) {
            String vector = (String)value;
            return new SparseFloatVector(vector);
        }
        throw this.unknownWrap(value.getClass());
    }

    private static class SparseVectorMutabilityPlan
    extends MutableMutabilityPlan<SparseFloatVector> {
        private SparseVectorMutabilityPlan() {
        }

        protected SparseFloatVector deepCopyNotNull(SparseFloatVector value) {
            return value.clone();
        }
    }
}

