/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector.internal;

import java.util.Arrays;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.tool.schema.extract.spi.ColumnTypeInformation;
import org.hibernate.type.BasicCollectionType;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.java.BasicPluralJavaType;
import org.hibernate.type.descriptor.java.ByteJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.MutableMutabilityPlan;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.vector.SparseByteVector;

public class SparseByteVectorJavaType
extends AbstractClassJavaType<SparseByteVector>
implements BasicPluralJavaType<Byte> {
    public static final SparseByteVectorJavaType INSTANCE = new SparseByteVectorJavaType();

    public SparseByteVectorJavaType() {
        super(SparseByteVector.class, (MutabilityPlan)new SparseVectorMutabilityPlan());
    }

    public JavaType<Byte> getElementJavaType() {
        return ByteJavaType.INSTANCE;
    }

    public BasicType<?> resolveType(TypeConfiguration typeConfiguration, Dialect dialect, BasicType<Byte> elementType, ColumnTypeInformation columnTypeInformation, JdbcTypeIndicators stdIndicators) {
        int arrayTypeCode = stdIndicators.getPreferredSqlTypeCodeForArray(elementType.getJdbcType().getDefaultSqlTypeCode());
        JdbcType arrayJdbcType = typeConfiguration.getJdbcTypeRegistry().resolveTypeConstructorDescriptor(arrayTypeCode, elementType, columnTypeInformation);
        if (elementType.getValueConverter() != null) {
            throw new IllegalArgumentException("Can't convert element type of sparse vector");
        }
        return typeConfiguration.getBasicTypeRegistry().resolve((JavaType)this, arrayJdbcType, () -> new BasicCollectionType(elementType, arrayJdbcType, (JavaType)this, "sparse_byte_vector"));
    }

    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators indicators) {
        return indicators.getJdbcType(10006);
    }

    public <X> X unwrap(SparseByteVector value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (type.isInstance(value)) {
            return (X)value;
        }
        if (byte[].class.isAssignableFrom(type)) {
            return (X)value.toDenseVector();
        }
        if (Object[].class.isAssignableFrom(type)) {
            return (X)value.toArray();
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)value.toString();
        }
        throw this.unknownUnwrap(type);
    }

    public <X> SparseByteVector wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof SparseByteVector) {
            SparseByteVector vector = (SparseByteVector)value;
            return vector;
        }
        if (value instanceof List) {
            List list = (List)value;
            return new SparseByteVector(list);
        }
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            return new SparseByteVector(Arrays.asList(array));
        }
        if (value instanceof byte[]) {
            byte[] vector = (byte[])value;
            return new SparseByteVector(vector);
        }
        if (value instanceof String) {
            String vector = (String)value;
            return new SparseByteVector(vector);
        }
        throw this.unknownWrap(value.getClass());
    }

    private static class SparseVectorMutabilityPlan
    extends MutableMutabilityPlan<SparseByteVector> {
        private SparseVectorMutabilityPlan() {
        }

        protected SparseByteVector deepCopyNotNull(SparseByteVector value) {
            return value.clone();
        }
    }
}

