/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector.internal;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import microsoft.sql.Vector;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.vector.internal.SQLServerCastingVectorJdbcType;

public class SQLServerVectorJdbcType
extends SQLServerCastingVectorJdbcType {
    public SQLServerVectorJdbcType(JdbcType elementJdbcType, int sqlType) {
        super(elementJdbcType, sqlType);
    }

    @Override
    public Expression wrapTopLevelSelectionExpression(Expression expression) {
        return expression;
    }

    @Override
    public void appendWriteExpression(String writeExpression, @Nullable Size size, SqlAppender appender, Dialect dialect) {
        appender.append((CharSequence)writeExpression);
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(javaTypeDescriptor, (JdbcType)this){

            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return this.getValue(rs.getObject(paramIndex, Vector.class), options);
            }

            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.getValue(statement.getObject(index, Vector.class), options);
            }

            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.getValue(statement.getObject(name, Vector.class), options);
            }

            private X getValue(Vector vector, WrapperOptions options) {
                if (vector == null) {
                    return null;
                }
                return this.getJavaType().wrap((Object)vector.getData(), options);
            }
        };
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaTypeDescriptor) {
        return new BasicBinder<X>(javaTypeDescriptor, (JdbcType)this){

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                st.setObject(index, this.getBindValue(value, options), -160);
            }

            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                st.setObject(name, this.getBindValue(value, options), -160);
            }

            protected void doBindNull(PreparedStatement st, int index, WrapperOptions options) throws SQLException {
                st.setNull(index, -160);
            }

            protected void doBindNull(CallableStatement st, String name, WrapperOptions options) throws SQLException {
                st.setNull(name, -160);
            }

            public Object getBindValue(X value, WrapperOptions options) {
                Object[] floats = (Float[])this.getJavaType().unwrap(value, Float[].class, options);
                return new Vector(floats.length, Vector.VectorDimensionType.FLOAT32, floats);
            }
        };
    }
}

