/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector.internal;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.sql.VECTOR;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.vector.SparseByteVector;
import org.hibernate.vector.internal.AbstractOracleSparseVectorJdbcType;
import org.hibernate.vector.internal.AbstractOracleVectorJdbcType;

public class OracleSparseByteVectorJdbcType
extends AbstractOracleSparseVectorJdbcType {
    public OracleSparseByteVectorJdbcType(JdbcType elementJdbcType, boolean isVectorSupported) {
        super(elementJdbcType, isVectorSupported);
    }

    @Override
    public String getVectorParameters() {
        return "*,int8,sparse";
    }

    public String getFriendlyName() {
        return "SPARSE_VECTOR_INT8";
    }

    public int getDefaultSqlTypeCode() {
        return 10006;
    }

    @Override
    protected <X> Object getBindValue(JavaType<X> javaType, X value, WrapperOptions options) {
        if (this.isVectorSupported) {
            SparseByteVector sparseVector = (SparseByteVector)javaType.unwrap(value, SparseByteVector.class, options);
            return VECTOR.SparseByteArray.of((int)sparseVector.size(), (int[])sparseVector.indices(), (byte[])sparseVector.bytes());
        }
        return this.getStringVector(value, javaType, options);
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(javaTypeDescriptor, (JdbcType)this){

            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                if (OracleSparseByteVectorJdbcType.this.isVectorSupported) {
                    return this.getJavaType().wrap(this.wrapNativeValue(rs.getObject(paramIndex, VECTOR.SparseByteArray.class)), options);
                }
                return this.getJavaType().wrap(this.wrapStringValue(rs.getString(paramIndex)), options);
            }

            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                if (OracleSparseByteVectorJdbcType.this.isVectorSupported) {
                    return this.getJavaType().wrap(this.wrapNativeValue(statement.getObject(index, VECTOR.SparseByteArray.class)), options);
                }
                return this.getJavaType().wrap(this.wrapStringValue(statement.getString(index)), options);
            }

            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                if (OracleSparseByteVectorJdbcType.this.isVectorSupported) {
                    return this.getJavaType().wrap(this.wrapNativeValue(statement.getObject(name, VECTOR.SparseByteArray.class)), options);
                }
                return this.getJavaType().wrap(this.wrapStringValue(statement.getString(name)), options);
            }

            private Object wrapNativeValue(VECTOR.SparseByteArray nativeValue) {
                return nativeValue == null ? null : new SparseByteVector(nativeValue.length(), nativeValue.indices(), nativeValue.values());
            }

            private Object wrapStringValue(String value) {
                return ((AbstractOracleVectorJdbcType)this.getJdbcType()).getVectorArray(value);
            }
        };
    }

    @Override
    protected SparseByteVector getVectorArray(String string) {
        if (string == null) {
            return null;
        }
        return new SparseByteVector(string);
    }

    @Override
    protected Class<?> getNativeJavaType() {
        return VECTOR.SparseByteArray.class;
    }
}

