/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector.internal;

import java.util.Arrays;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.vector.internal.AbstractOracleVectorJdbcType;
import org.hibernate.vector.internal.VectorHelper;

public class OracleFloatVectorJdbcType
extends AbstractOracleVectorJdbcType {
    public OracleFloatVectorJdbcType(JdbcType elementJdbcType, boolean isVectorSupported) {
        super(elementJdbcType, isVectorSupported);
    }

    @Override
    public String getVectorParameters() {
        return "*,float32";
    }

    public String getFriendlyName() {
        return "VECTOR_FLOAT32";
    }

    public int getDefaultSqlTypeCode() {
        return 10002;
    }

    protected float[] getVectorArray(String string) {
        return VectorHelper.parseFloatVector(string);
    }

    @Override
    protected <T> String getStringVector(T vector, JavaType<T> javaTypeDescriptor, WrapperOptions options) {
        return Arrays.toString((float[])javaTypeDescriptor.unwrap(vector, float[].class, options));
    }

    @Override
    protected Class<?> getNativeJavaType() {
        return float[].class;
    }

    @Override
    protected int getNativeTypeCode() {
        return -107;
    }
}

