/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector.internal;

import java.util.Arrays;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.vector.internal.AbstractOracleVectorJdbcType;
import org.hibernate.vector.internal.VectorHelper;

public class OracleByteVectorJdbcType
extends AbstractOracleVectorJdbcType {
    public OracleByteVectorJdbcType(JdbcType elementJdbcType, boolean isVectorSupported) {
        super(elementJdbcType, isVectorSupported);
    }

    @Override
    public String getVectorParameters() {
        return "*,int8";
    }

    public String getFriendlyName() {
        return "VECTOR_INT8";
    }

    public int getDefaultSqlTypeCode() {
        return 10001;
    }

    protected byte[] getVectorArray(String string) {
        return VectorHelper.parseByteVector(string);
    }

    @Override
    protected <T> String getStringVector(T vector, JavaType<T> javaTypeDescriptor, WrapperOptions options) {
        return Arrays.toString((byte[])javaTypeDescriptor.unwrap(vector, byte[].class, options));
    }

    @Override
    protected Class<?> getNativeJavaType() {
        return byte[].class;
    }

    @Override
    protected int getNativeTypeCode() {
        return -106;
    }
}

