/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector.internal;

import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.FunctionContributor;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.vector.internal.VectorFunctionFactory;

public class MySQLFunctionContributor
implements FunctionContributor {
    public void contributeFunctions(FunctionContributions functionContributions) {
        MySQLDialect mySQLDialect;
        Dialect dialect = functionContributions.getDialect();
        if (dialect instanceof MySQLDialect && (mySQLDialect = (MySQLDialect)dialect).getMySQLVersion().isSameOrAfter(9, 0)) {
            VectorFunctionFactory vectorFunctionFactory = new VectorFunctionFactory(functionContributions);
            vectorFunctionFactory.cosineDistance("distance(?1,?2,'cosine')");
            vectorFunctionFactory.euclideanDistance("distance(?1,?2,'euclidean')");
            vectorFunctionFactory.innerProduct("distance(?1,?2,'dot')*-1");
            vectorFunctionFactory.negativeInnerProduct("distance(?1,?2,'dot')");
            vectorFunctionFactory.registerNamedVectorFunction("vector_dim", functionContributions.getTypeConfiguration().getBasicTypeForJavaType(Integer.class), 1);
            functionContributions.getFunctionRegistry().registerAlternateKey("vector_dims", "vector_dim");
        }
    }

    public int ordinal() {
        return 200;
    }
}

