/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector.internal;

import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.TypeContributor;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.BasicArrayType;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.vector.internal.DB2ByteVectorJdbcType;
import org.hibernate.vector.internal.DB2FloatVectorJdbcType;
import org.hibernate.vector.internal.DB2VectorJdbcType;
import org.hibernate.vector.internal.VectorDdlType;

public class DB2VectorTypeContributor
implements TypeContributor {
    public void contribute(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        DB2Dialect db2Dialect;
        Dialect dialect = ((JdbcServices)serviceRegistry.requireService(JdbcServices.class)).getDialect();
        if (dialect instanceof DB2Dialect && (db2Dialect = (DB2Dialect)dialect).getDB2Version().isSameOrAfter(12, 1, 2)) {
            TypeConfiguration typeConfiguration = typeContributions.getTypeConfiguration();
            JavaTypeRegistry javaTypeRegistry = typeConfiguration.getJavaTypeRegistry();
            JdbcTypeRegistry jdbcTypeRegistry = typeConfiguration.getJdbcTypeRegistry();
            BasicTypeRegistry basicTypeRegistry = typeConfiguration.getBasicTypeRegistry();
            BasicType floatBasicType = basicTypeRegistry.resolve(StandardBasicTypes.FLOAT);
            DB2VectorJdbcType genericVectorJdbcType = new DB2VectorJdbcType(jdbcTypeRegistry.getDescriptor(6));
            jdbcTypeRegistry.addDescriptor(10000, (JdbcType)genericVectorJdbcType);
            DB2FloatVectorJdbcType floatVectorJdbcType = new DB2FloatVectorJdbcType(jdbcTypeRegistry.getDescriptor(6));
            jdbcTypeRegistry.addDescriptor(10002, (JdbcType)floatVectorJdbcType);
            DB2ByteVectorJdbcType byteVectorJdbcType = new DB2ByteVectorJdbcType(jdbcTypeRegistry.getDescriptor(-6));
            jdbcTypeRegistry.addDescriptor(10001, (JdbcType)byteVectorJdbcType);
            basicTypeRegistry.register((BasicType)new BasicArrayType(floatBasicType, (JdbcType)genericVectorJdbcType, javaTypeRegistry.getDescriptor(float[].class)), StandardBasicTypes.VECTOR.getName());
            basicTypeRegistry.register((BasicType)new BasicArrayType(basicTypeRegistry.resolve(StandardBasicTypes.FLOAT), (JdbcType)floatVectorJdbcType, javaTypeRegistry.getDescriptor(float[].class)), StandardBasicTypes.VECTOR_FLOAT32.getName());
            basicTypeRegistry.register((BasicType)new BasicArrayType(basicTypeRegistry.resolve(StandardBasicTypes.BYTE), (JdbcType)byteVectorJdbcType, javaTypeRegistry.getDescriptor(byte[].class)), StandardBasicTypes.VECTOR_INT8.getName());
            typeConfiguration.getDdlTypeRegistry().addDescriptor((DdlType)new VectorDdlType(10000, "vector($l,float32)", "vector", dialect));
            typeConfiguration.getDdlTypeRegistry().addDescriptor((DdlType)new VectorDdlType(10001, "vector($l,int8)", "vector", dialect));
            typeConfiguration.getDdlTypeRegistry().addDescriptor((DdlType)new VectorDdlType(10002, "vector($l,float32)", "vector", dialect));
        }
    }
}

