/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector.internal;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.BasicPluralJavaType;
import org.hibernate.type.descriptor.java.ByteJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayJavaType;
import org.hibernate.type.descriptor.jdbc.ArrayJdbcType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.vector.internal.DB2JdbcLiteralFormatterVector;

public abstract class AbstractDB2VectorJdbcType
extends ArrayJdbcType {
    public AbstractDB2VectorJdbcType(JdbcType elementJdbcType) {
        super(elementJdbcType);
    }

    public @Nullable String castToPattern(JdbcMapping targetJdbcMapping, @Nullable Size size) {
        return targetJdbcMapping.getJdbcType().isStringLike() ? "vector_serialize(?1 returning ?2)" : null;
    }

    public @Nullable String castFromPattern(JdbcMapping sourceMapping, @Nullable Size size) {
        return sourceMapping.getJdbcType().isStringLike() ? "vector(?1," + this.getVectorParameters(size) + ")" : null;
    }

    public void appendWriteExpression(String writeExpression, @Nullable Size size, SqlAppender appender, Dialect dialect) {
        appender.append((CharSequence)"vector(");
        appender.append((CharSequence)writeExpression);
        appender.append(',');
        appender.append((CharSequence)this.getVectorParameters(size));
        appender.append(')');
    }

    public boolean isWriteExpressionTyped(Dialect dialect) {
        return true;
    }

    public abstract String getVectorParameters(@Nullable Size var1);

    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaTypeDescriptor) {
        ByteJavaType elementJavaType;
        if (javaTypeDescriptor instanceof PrimitiveByteArrayJavaType) {
            elementJavaType = ByteJavaType.INSTANCE;
        } else if (javaTypeDescriptor instanceof BasicPluralJavaType) {
            elementJavaType = ((BasicPluralJavaType)javaTypeDescriptor).getElementJavaType();
        } else {
            throw new IllegalArgumentException("not a BasicPluralJavaType");
        }
        return new DB2JdbcLiteralFormatterVector<T>(javaTypeDescriptor, this.getElementJdbcType().getJdbcLiteralFormatter((JavaType)elementJavaType), this);
    }

    public String toString() {
        return "DB2VectorTypeDescriptor";
    }

    public <X> ValueBinder<X> getBinder(JavaType<X> javaTypeDescriptor) {
        return new BasicBinder<X>(javaTypeDescriptor, (JdbcType)this){

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                st.setString(index, ((AbstractDB2VectorJdbcType)this.getJdbcType()).getStringVector(value, this.getJavaType(), options));
            }

            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                st.setString(name, ((AbstractDB2VectorJdbcType)this.getJdbcType()).getStringVector(value, this.getJavaType(), options));
            }
        };
    }

    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(javaTypeDescriptor, (JdbcType)this){

            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap(((AbstractDB2VectorJdbcType)this.getJdbcType()).getVectorArray(rs.getString(paramIndex)), options);
            }

            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap(((AbstractDB2VectorJdbcType)this.getJdbcType()).getVectorArray(statement.getString(index)), options);
            }

            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap(((AbstractDB2VectorJdbcType)this.getJdbcType()).getVectorArray(statement.getString(name)), options);
            }
        };
    }

    protected abstract Object getVectorArray(String var1);

    protected abstract <T> String getStringVector(T var1, JavaType<T> var2, WrapperOptions var3);
}

