/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector.internal;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import org.checkerframework.checker.nullness.qual.Nullable;

public class VectorHelper {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    private static final double[] EMPTY_DOUBLE_ARRAY = new double[0];

    public static @Nullable byte[] parseByteVector(@Nullable String string) {
        int commaIndex;
        if (string == null) {
            return null;
        }
        if (string.length() == 2) {
            return EMPTY_BYTE_ARRAY;
        }
        BitSet commaPositions = new BitSet();
        int size = 1;
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != ',') continue;
            commaPositions.set(i);
            ++size;
        }
        byte[] result = new byte[size];
        int doubleStartIndex = 1;
        int index = 0;
        while ((commaIndex = commaPositions.nextSetBit(doubleStartIndex)) != -1) {
            result[index++] = Byte.parseByte(string.substring(doubleStartIndex, commaIndex));
            doubleStartIndex = commaIndex + 1;
        }
        result[index] = Byte.parseByte(string.substring(doubleStartIndex, string.length() - 1));
        return result;
    }

    public static @Nullable float[] parseFloatVector(@Nullable String string) {
        int commaIndex;
        if (string == null) {
            return null;
        }
        if (string.length() == 2) {
            return EMPTY_FLOAT_ARRAY;
        }
        BitSet commaPositions = new BitSet();
        int size = 1;
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != ',') continue;
            commaPositions.set(i);
            ++size;
        }
        float[] result = new float[size];
        int doubleStartIndex = 1;
        int index = 0;
        while ((commaIndex = commaPositions.nextSetBit(doubleStartIndex)) != -1) {
            result[index++] = Float.parseFloat(string.substring(doubleStartIndex, commaIndex));
            doubleStartIndex = commaIndex + 1;
        }
        result[index] = Float.parseFloat(string.substring(doubleStartIndex, string.length() - 1));
        return result;
    }

    public static @Nullable double[] parseDoubleVector(@Nullable String string) {
        int commaIndex;
        if (string == null) {
            return null;
        }
        if (string.length() == 2) {
            return EMPTY_DOUBLE_ARRAY;
        }
        BitSet commaPositions = new BitSet();
        int size = 1;
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != ',') continue;
            commaPositions.set(i);
            ++size;
        }
        double[] result = new double[size];
        int doubleStartIndex = 1;
        int index = 0;
        while ((commaIndex = commaPositions.nextSetBit(doubleStartIndex)) != -1) {
            result[index++] = Double.parseDouble(string.substring(doubleStartIndex, commaIndex));
            doubleStartIndex = commaIndex + 1;
        }
        result[index] = Double.parseDouble(string.substring(doubleStartIndex, string.length() - 1));
        return result;
    }

    public static @Nullable float[] parseFloatVector(@Nullable byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (bytes.length == 0) {
            return EMPTY_FLOAT_ARRAY;
        }
        if ((bytes.length & 3) != 0) {
            throw new IllegalArgumentException("Invalid byte array length. Expected a multiple of 4 but got: " + bytes.length);
        }
        float[] result = new float[bytes.length >> 2];
        int resultLength = result.length;
        for (int i = 0; i < resultLength; ++i) {
            int offset = i << 2;
            int asInt = bytes[offset] & 0xFF | (bytes[offset + 1] & 0xFF) << 8 | (bytes[offset + 2] & 0xFF) << 16 | (bytes[offset + 3] & 0xFF) << 24;
            result[i] = Float.intBitsToFloat(asInt);
        }
        return result;
    }

    public static byte[] parseBitString(String bitString) {
        int i;
        assert (new BigInteger("1" + bitString, 2).bitLength() == bitString.length() + 1);
        int fullBytesCount = bitString.length() >> 3;
        int fullBytesStartPosition = (bitString.length() & 7) == 0 ? 0 : 1;
        int byteCount = fullBytesCount + fullBytesStartPosition;
        byte[] bytes = new byte[byteCount];
        int fullBytesBitCount = fullBytesCount << 3;
        int leadingBits = bitString.length() - fullBytesBitCount;
        if (leadingBits > 0) {
            for (i = 0; i < leadingBits; ++i) {
                bytes[0] = (byte)(bytes[0] | (byte)(bitString.charAt(i) - 48 << 7 - i));
            }
        }
        for (i = fullBytesStartPosition; i < fullBytesCount; ++i) {
            bytes[i] = (byte)(bitString.charAt(i * 8 + 0) - 48 << 7 | bitString.charAt(i * 8 + 1) - 48 << 6 | bitString.charAt(i * 8 + 2) - 48 << 5 | bitString.charAt(i * 8 + 3) - 48 << 4 | bitString.charAt(i * 8 + 4) - 48 << 3 | bitString.charAt(i * 8 + 5) - 48 << 2 | bitString.charAt(i * 8 + 6) - 48 << 1 | bitString.charAt(i * 8 + 7) - 48 << 0);
        }
        return bytes;
    }

    public static String toBitString(byte[] bytes) {
        byte[] bitBytes = new byte[bytes.length * 8];
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            bitBytes[i * 8 + 0] = (byte)((b >>> 7 & 1) + 48);
            bitBytes[i * 8 + 1] = (byte)((b >>> 6 & 1) + 48);
            bitBytes[i * 8 + 2] = (byte)((b >>> 5 & 1) + 48);
            bitBytes[i * 8 + 3] = (byte)((b >>> 4 & 1) + 48);
            bitBytes[i * 8 + 4] = (byte)((b >>> 3 & 1) + 48);
            bitBytes[i * 8 + 5] = (byte)((b >>> 2 & 1) + 48);
            bitBytes[i * 8 + 6] = (byte)((b >>> 1 & 1) + 48);
            bitBytes[i * 8 + 7] = (byte)((b >>> 0 & 1) + 48);
        }
        return new String(bitBytes, StandardCharsets.UTF_8);
    }
}

