/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector.internal;

import org.hibernate.dialect.Dialect;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.spi.BasicJdbcLiteralFormatter;
import org.hibernate.vector.AbstractSparseVector;
import org.hibernate.vector.SparseByteVector;
import org.hibernate.vector.SparseDoubleVector;
import org.hibernate.vector.SparseFloatVector;

public class PGVectorJdbcLiteralFormatterSparseVector<T>
extends BasicJdbcLiteralFormatter<T> {
    public PGVectorJdbcLiteralFormatterSparseVector(JavaType<T> javaType) {
        super(javaType);
    }

    public void appendJdbcLiteral(SqlAppender appender, T value, Dialect dialect, WrapperOptions wrapperOptions) {
        appender.append((CharSequence)"cast('");
        AbstractSparseVector sparseVector = (AbstractSparseVector)this.unwrap(value, AbstractSparseVector.class, wrapperOptions);
        int separator = 123;
        int[] indices = sparseVector.indices();
        if (sparseVector instanceof SparseFloatVector) {
            SparseFloatVector floatVector = (SparseFloatVector)sparseVector;
            float[] floats = floatVector.floats();
            for (int i = 0; i < floats.length; ++i) {
                appender.appendSql((char)separator);
                appender.appendSql(indices[i] + 1);
                appender.appendSql(':');
                appender.appendSql(floats[i]);
                separator = 44;
            }
        } else if (sparseVector instanceof SparseDoubleVector) {
            SparseDoubleVector doubleVector = (SparseDoubleVector)sparseVector;
            double[] doubles = doubleVector.doubles();
            for (int i = 0; i < doubles.length; ++i) {
                appender.appendSql((char)separator);
                appender.appendSql(indices[i] + 1);
                appender.appendSql(':');
                appender.appendSql(doubles[i]);
                separator = 44;
            }
        } else if (sparseVector instanceof SparseByteVector) {
            SparseByteVector byteVector = (SparseByteVector)sparseVector;
            byte[] bytes = byteVector.bytes();
            for (int i = 0; i < bytes.length; ++i) {
                appender.appendSql((char)separator);
                appender.appendSql(indices[i] + 1);
                appender.appendSql(':');
                appender.appendSql((int)bytes[i]);
                separator = 44;
            }
        } else {
            throw new IllegalArgumentException("Unsupported sparse vector type: " + sparseVector.getClass().getName());
        }
        appender.append((CharSequence)"}/");
        appender.appendSql(sparseVector.size());
        appender.append((CharSequence)"' as sparsevec)");
    }
}

