/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector.internal;

import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.FunctionContributor;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionArgumentTypeResolver;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.type.BasicType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.vector.internal.PGVectorDimsFunction;
import org.hibernate.vector.internal.PGVectorNormFunction;
import org.hibernate.vector.internal.VectorArgumentTypeResolver;
import org.hibernate.vector.internal.VectorArgumentValidator;
import org.hibernate.vector.internal.VectorFunctionFactory;

public class PGVectorFunctionContributor
implements FunctionContributor {
    public void contributeFunctions(FunctionContributions functionContributions) {
        Dialect dialect = functionContributions.getDialect();
        if (dialect instanceof PostgreSQLDialect) {
            VectorFunctionFactory vectorFunctionFactory = new VectorFunctionFactory(functionContributions);
            vectorFunctionFactory.cosineDistance("?1<=>?2");
            vectorFunctionFactory.euclideanDistance("?1<->?2");
            vectorFunctionFactory.euclideanSquaredDistance("(?1<->?2)^2");
            vectorFunctionFactory.l1Distance("l1_distance(?1,?2)");
            vectorFunctionFactory.hammingDistance("?1<~>?2");
            vectorFunctionFactory.jaccardDistance("?1<%>?2");
            vectorFunctionFactory.innerProduct("(?1<#>?2)*-1");
            vectorFunctionFactory.negativeInnerProduct("?1<#>?2");
            TypeConfiguration typeConfiguration = functionContributions.getTypeConfiguration();
            functionContributions.getFunctionRegistry().register("vector_dims", (SqmFunctionDescriptor)new PGVectorDimsFunction(typeConfiguration));
            functionContributions.getFunctionRegistry().register("vector_norm", (SqmFunctionDescriptor)new PGVectorNormFunction(typeConfiguration));
            functionContributions.getFunctionRegistry().namedDescriptorBuilder("binary_quantize").setArgumentsValidator(StandardArgumentsValidators.composite((ArgumentsValidator[])new ArgumentsValidator[]{StandardArgumentsValidators.exactly((int)1), VectorArgumentValidator.INSTANCE})).setArgumentTypeResolver(VectorArgumentTypeResolver.INSTANCE).setReturnTypeResolver(StandardFunctionReturnTypeResolvers.invariant((BasicType)typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.VECTOR_BINARY))).register();
            functionContributions.getFunctionRegistry().namedDescriptorBuilder("subvector").setArgumentsValidator(StandardArgumentsValidators.composite((ArgumentsValidator[])new ArgumentsValidator[]{StandardArgumentsValidators.exactly((int)3), VectorArgumentValidator.INSTANCE})).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.byArgument((FunctionArgumentTypeResolver[])new FunctionArgumentTypeResolver[]{VectorArgumentTypeResolver.INSTANCE, StandardFunctionArgumentTypeResolvers.invariant((TypeConfiguration)typeConfiguration, (FunctionParameterType)FunctionParameterType.INTEGER), StandardFunctionArgumentTypeResolvers.invariant((TypeConfiguration)typeConfiguration, (FunctionParameterType)FunctionParameterType.INTEGER)})).setReturnTypeResolver(StandardFunctionReturnTypeResolvers.useArgType((int)1)).register();
            functionContributions.getFunctionRegistry().registerAlternateKey("l2_norm", "vector_norm");
            functionContributions.getFunctionRegistry().namedDescriptorBuilder("l2_normalize").setArgumentsValidator(VectorArgumentValidator.INSTANCE).setArgumentTypeResolver(VectorArgumentTypeResolver.INSTANCE).setReturnTypeResolver(StandardFunctionReturnTypeResolvers.useArgType((int)1)).register();
        }
    }

    public int ordinal() {
        return 200;
    }
}

