/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector.internal;

import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.TypeContributor;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.BasicArrayType;
import org.hibernate.type.BasicCollectionType;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.vector.internal.OracleBinaryVectorJdbcType;
import org.hibernate.vector.internal.OracleByteVectorJdbcType;
import org.hibernate.vector.internal.OracleDoubleVectorJdbcType;
import org.hibernate.vector.internal.OracleFloatVectorJdbcType;
import org.hibernate.vector.internal.OracleSparseByteVectorJdbcType;
import org.hibernate.vector.internal.OracleSparseDoubleVectorJdbcType;
import org.hibernate.vector.internal.OracleSparseFloatVectorJdbcType;
import org.hibernate.vector.internal.OracleVectorJdbcType;
import org.hibernate.vector.internal.SparseByteVectorJavaType;
import org.hibernate.vector.internal.SparseDoubleVectorJavaType;
import org.hibernate.vector.internal.SparseFloatVectorJavaType;
import org.hibernate.vector.internal.VectorDdlType;

public class OracleVectorTypeContributor
implements TypeContributor {
    public void contribute(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        Dialect dialect = ((JdbcServices)serviceRegistry.requireService(JdbcServices.class)).getDialect();
        if (dialect instanceof OracleDialect && dialect.getVersion().isSameOrAfter(23, 4)) {
            TypeConfiguration typeConfiguration = typeContributions.getTypeConfiguration();
            JavaTypeRegistry javaTypeRegistry = typeConfiguration.getJavaTypeRegistry();
            JdbcTypeRegistry jdbcTypeRegistry = typeConfiguration.getJdbcTypeRegistry();
            BasicTypeRegistry basicTypeRegistry = typeConfiguration.getBasicTypeRegistry();
            boolean isVectorSupported = this.isVectorSupportedByDriver((OracleDialect)dialect);
            OracleVectorJdbcType genericVectorJdbcType = new OracleVectorJdbcType(jdbcTypeRegistry.getDescriptor(6), isVectorSupported);
            jdbcTypeRegistry.addDescriptor(10000, (JdbcType)genericVectorJdbcType);
            OracleFloatVectorJdbcType floatVectorJdbcType = new OracleFloatVectorJdbcType(jdbcTypeRegistry.getDescriptor(6), isVectorSupported);
            jdbcTypeRegistry.addDescriptor(10002, (JdbcType)floatVectorJdbcType);
            OracleDoubleVectorJdbcType doubleVectorJdbcType = new OracleDoubleVectorJdbcType(jdbcTypeRegistry.getDescriptor(8), isVectorSupported);
            jdbcTypeRegistry.addDescriptor(10003, (JdbcType)doubleVectorJdbcType);
            OracleByteVectorJdbcType byteVectorJdbcType = new OracleByteVectorJdbcType(jdbcTypeRegistry.getDescriptor(-6), isVectorSupported);
            jdbcTypeRegistry.addDescriptor(10001, (JdbcType)byteVectorJdbcType);
            OracleBinaryVectorJdbcType bitVectorJdbcType = new OracleBinaryVectorJdbcType(jdbcTypeRegistry.getDescriptor(-6), isVectorSupported);
            jdbcTypeRegistry.addDescriptor(10004, (JdbcType)bitVectorJdbcType);
            OracleSparseByteVectorJdbcType sparseByteVectorJdbcType = new OracleSparseByteVectorJdbcType(jdbcTypeRegistry.getDescriptor(-6), isVectorSupported);
            jdbcTypeRegistry.addDescriptor(10006, (JdbcType)sparseByteVectorJdbcType);
            OracleSparseFloatVectorJdbcType sparseFloatVectorJdbcType = new OracleSparseFloatVectorJdbcType(jdbcTypeRegistry.getDescriptor(6), isVectorSupported);
            jdbcTypeRegistry.addDescriptor(10007, (JdbcType)sparseFloatVectorJdbcType);
            OracleSparseDoubleVectorJdbcType sparseDoubleVectorJdbcType = new OracleSparseDoubleVectorJdbcType(jdbcTypeRegistry.getDescriptor(8), isVectorSupported);
            jdbcTypeRegistry.addDescriptor(10008, (JdbcType)sparseDoubleVectorJdbcType);
            javaTypeRegistry.addDescriptor((JavaType)SparseByteVectorJavaType.INSTANCE);
            javaTypeRegistry.addDescriptor((JavaType)SparseFloatVectorJavaType.INSTANCE);
            javaTypeRegistry.addDescriptor((JavaType)SparseDoubleVectorJavaType.INSTANCE);
            basicTypeRegistry.register((BasicType)new BasicArrayType(basicTypeRegistry.resolve(StandardBasicTypes.FLOAT), (JdbcType)genericVectorJdbcType, javaTypeRegistry.getDescriptor(float[].class)), StandardBasicTypes.VECTOR.getName());
            basicTypeRegistry.register((BasicType)new BasicArrayType(basicTypeRegistry.resolve(StandardBasicTypes.FLOAT), (JdbcType)floatVectorJdbcType, javaTypeRegistry.getDescriptor(float[].class)), StandardBasicTypes.VECTOR_FLOAT32.getName());
            basicTypeRegistry.register((BasicType)new BasicArrayType(basicTypeRegistry.resolve(StandardBasicTypes.DOUBLE), (JdbcType)doubleVectorJdbcType, javaTypeRegistry.getDescriptor(double[].class)), StandardBasicTypes.VECTOR_FLOAT64.getName());
            basicTypeRegistry.register((BasicType)new BasicArrayType(basicTypeRegistry.resolve(StandardBasicTypes.BYTE), (JdbcType)byteVectorJdbcType, javaTypeRegistry.getDescriptor(byte[].class)), StandardBasicTypes.VECTOR_INT8.getName());
            basicTypeRegistry.register((BasicType)new BasicArrayType(basicTypeRegistry.resolve(StandardBasicTypes.BYTE), (JdbcType)bitVectorJdbcType, javaTypeRegistry.getDescriptor(byte[].class)), StandardBasicTypes.VECTOR_BINARY.getName());
            basicTypeRegistry.register((BasicType)new BasicCollectionType(basicTypeRegistry.resolve(StandardBasicTypes.BYTE), (JdbcType)sparseByteVectorJdbcType, (JavaType)SparseByteVectorJavaType.INSTANCE, "sparse_byte_vector"));
            basicTypeRegistry.register((BasicType)new BasicCollectionType(basicTypeRegistry.resolve(StandardBasicTypes.FLOAT), (JdbcType)sparseFloatVectorJdbcType, (JavaType)SparseFloatVectorJavaType.INSTANCE, "sparse_float_vector"));
            basicTypeRegistry.register((BasicType)new BasicCollectionType(basicTypeRegistry.resolve(StandardBasicTypes.DOUBLE), (JdbcType)sparseDoubleVectorJdbcType, (JavaType)SparseDoubleVectorJavaType.INSTANCE, "sparse_double_vector"));
            typeConfiguration.getDdlTypeRegistry().addDescriptor((DdlType)new VectorDdlType(10000, "vector($l,*)", "vector", dialect));
            typeConfiguration.getDdlTypeRegistry().addDescriptor((DdlType)new VectorDdlType(10001, "vector($l,int8)", "vector", dialect));
            typeConfiguration.getDdlTypeRegistry().addDescriptor((DdlType)new VectorDdlType(10002, "vector($l,float32)", "vector", dialect));
            typeConfiguration.getDdlTypeRegistry().addDescriptor((DdlType)new VectorDdlType(10003, "vector($l,float64)", "vector", dialect));
            typeConfiguration.getDdlTypeRegistry().addDescriptor((DdlType)new VectorDdlType(10004, "vector($l,binary)", "vector", dialect));
            typeConfiguration.getDdlTypeRegistry().addDescriptor((DdlType)new VectorDdlType(10006, "vector($l,int8,sparse)", "vector", dialect));
            typeConfiguration.getDdlTypeRegistry().addDescriptor((DdlType)new VectorDdlType(10007, "vector($l,float32,sparse)", "vector", dialect));
            typeConfiguration.getDdlTypeRegistry().addDescriptor((DdlType)new VectorDdlType(10008, "vector($l,float64,sparse)", "vector", dialect));
        }
    }

    private boolean isVectorSupportedByDriver(OracleDialect dialect) {
        int majorVersion = dialect.getDriverMajorVersion();
        int minorVersion = dialect.getDriverMinorVersion();
        return majorVersion > 23 || majorVersion == 23 && minorVersion >= 4;
    }
}

