/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector.internal;

import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.TypeContributor;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.BasicArrayType;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.vector.internal.MySQLVectorJdbcType;
import org.hibernate.vector.internal.VectorDdlType;

public class MySQLTypeContributor
implements TypeContributor {
    public void contribute(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        MySQLDialect mySQLDialect;
        Dialect dialect = ((JdbcServices)serviceRegistry.requireService(JdbcServices.class)).getDialect();
        if (dialect instanceof MySQLDialect && (mySQLDialect = (MySQLDialect)dialect).getMySQLVersion().isSameOrAfter(9, 0)) {
            TypeConfiguration typeConfiguration = typeContributions.getTypeConfiguration();
            JavaTypeRegistry javaTypeRegistry = typeConfiguration.getJavaTypeRegistry();
            JdbcTypeRegistry jdbcTypeRegistry = typeConfiguration.getJdbcTypeRegistry();
            BasicTypeRegistry basicTypeRegistry = typeConfiguration.getBasicTypeRegistry();
            BasicType floatBasicType = basicTypeRegistry.resolve(StandardBasicTypes.FLOAT);
            MySQLVectorJdbcType genericVectorJdbcType = new MySQLVectorJdbcType(jdbcTypeRegistry.getDescriptor(6), 10000);
            jdbcTypeRegistry.addDescriptor(10000, (JdbcType)genericVectorJdbcType);
            MySQLVectorJdbcType floatVectorJdbcType = new MySQLVectorJdbcType(jdbcTypeRegistry.getDescriptor(6), 10002);
            jdbcTypeRegistry.addDescriptor(10002, (JdbcType)floatVectorJdbcType);
            basicTypeRegistry.register((BasicType)new BasicArrayType(floatBasicType, (JdbcType)genericVectorJdbcType, javaTypeRegistry.getDescriptor(float[].class)), StandardBasicTypes.VECTOR.getName());
            basicTypeRegistry.register((BasicType)new BasicArrayType(basicTypeRegistry.resolve(StandardBasicTypes.FLOAT), (JdbcType)floatVectorJdbcType, javaTypeRegistry.getDescriptor(float[].class)), StandardBasicTypes.VECTOR_FLOAT32.getName());
            typeConfiguration.getDdlTypeRegistry().addDescriptor((DdlType)new VectorDdlType(10000, "vector($l)", "vector", dialect));
            typeConfiguration.getDdlTypeRegistry().addDescriptor((DdlType)new VectorDdlType(10002, "vector($l)", "vector", dialect));
        }
    }
}

