/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector.internal;

import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.FunctionContributor;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MariaDBDialect;
import org.hibernate.vector.internal.VectorFunctionFactory;

public class MariaDBFunctionContributor
implements FunctionContributor {
    public void contributeFunctions(FunctionContributions functionContributions) {
        Dialect dialect = functionContributions.getDialect();
        if (dialect instanceof MariaDBDialect && dialect.getVersion().isSameOrAfter(11, 7)) {
            VectorFunctionFactory vectorFunctionFactory = new VectorFunctionFactory(functionContributions);
            vectorFunctionFactory.cosineDistance("vec_distance_cosine(?1,?2)");
            vectorFunctionFactory.euclideanDistance("vec_distance_euclidean(?1,?2)");
        }
    }

    public int ordinal() {
        return 200;
    }
}

