/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector.internal;

import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.TypeContributor;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.HANADialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.BasicArrayType;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.vector.internal.HANAVectorJdbcType;
import org.hibernate.vector.internal.VectorDdlType;

public class HANAVectorTypeContributor
implements TypeContributor {
    public void contribute(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        HANADialect hanaDialect;
        Dialect dialect = ((JdbcServices)serviceRegistry.requireService(JdbcServices.class)).getDialect();
        if (dialect instanceof HANADialect && (hanaDialect = (HANADialect)dialect).isCloud()) {
            TypeConfiguration typeConfiguration = typeContributions.getTypeConfiguration();
            JavaTypeRegistry javaTypeRegistry = typeConfiguration.getJavaTypeRegistry();
            JdbcTypeRegistry jdbcTypeRegistry = typeConfiguration.getJdbcTypeRegistry();
            BasicTypeRegistry basicTypeRegistry = typeConfiguration.getBasicTypeRegistry();
            BasicType floatBasicType = basicTypeRegistry.resolve(StandardBasicTypes.FLOAT);
            HANAVectorJdbcType genericVectorJdbcType = new HANAVectorJdbcType(jdbcTypeRegistry.getDescriptor(6), 10000, "real_vector");
            jdbcTypeRegistry.addDescriptor(10000, (JdbcType)genericVectorJdbcType);
            HANAVectorJdbcType floatVectorJdbcType = new HANAVectorJdbcType(jdbcTypeRegistry.getDescriptor(6), 10002, "real_vector");
            basicTypeRegistry.register((BasicType)new BasicArrayType(floatBasicType, (JdbcType)genericVectorJdbcType, javaTypeRegistry.getDescriptor(float[].class)), StandardBasicTypes.VECTOR.getName());
            basicTypeRegistry.register((BasicType)new BasicArrayType(basicTypeRegistry.resolve(StandardBasicTypes.FLOAT), (JdbcType)floatVectorJdbcType, javaTypeRegistry.getDescriptor(float[].class)), StandardBasicTypes.VECTOR_FLOAT32.getName());
            typeConfiguration.getDdlTypeRegistry().addDescriptor((DdlType)new VectorDdlType(10000, "real_vector($l)", "real_vector", dialect));
            typeConfiguration.getDdlTypeRegistry().addDescriptor((DdlType)new VectorDdlType(10002, "real_vector($l)", "real_vector", dialect));
            if (hanaDialect.getVersion().isSameOrAfter(4, 20252)) {
                jdbcTypeRegistry.addDescriptor(10002, (JdbcType)floatVectorJdbcType);
                HANAVectorJdbcType float16VectorJdbcType = new HANAVectorJdbcType(jdbcTypeRegistry.getDescriptor(6), 10005, "half_vector");
                jdbcTypeRegistry.addDescriptor(10005, (JdbcType)float16VectorJdbcType);
                basicTypeRegistry.register((BasicType)new BasicArrayType(basicTypeRegistry.resolve(StandardBasicTypes.FLOAT), (JdbcType)float16VectorJdbcType, javaTypeRegistry.getDescriptor(float[].class)), StandardBasicTypes.VECTOR_FLOAT16.getName());
                typeConfiguration.getDdlTypeRegistry().addDescriptor((DdlType)new VectorDdlType(10005, "half_vector($l)", "half_vector", dialect));
            }
        }
    }
}

