/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector.internal;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.ArrayJdbcType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.vector.internal.HANAJdbcLiteralFormatterVector;
import org.hibernate.vector.internal.VectorHelper;

public class HANAVectorJdbcType
extends ArrayJdbcType {
    private final int sqlType;
    private final String typeName;

    public HANAVectorJdbcType(JdbcType elementJdbcType, int sqlType, String typeName) {
        super(elementJdbcType);
        this.sqlType = sqlType;
        this.typeName = typeName;
    }

    public int getDefaultSqlTypeCode() {
        return this.sqlType;
    }

    public <T> JavaType<T> getJdbcRecommendedJavaTypeMapping(Integer precision, Integer scale, TypeConfiguration typeConfiguration) {
        return typeConfiguration.getJavaTypeRegistry().getDescriptor(float[].class);
    }

    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaTypeDescriptor) {
        return new HANAJdbcLiteralFormatterVector<T>(javaTypeDescriptor, this.getElementJdbcType().getJdbcLiteralFormatter(HANAVectorJdbcType.elementJavaType(javaTypeDescriptor)), this.typeName);
    }

    public @Nullable String castToPattern(JdbcMapping targetJdbcMapping, @Nullable Size size) {
        JdbcType jdbcType = targetJdbcMapping.getJdbcType();
        return jdbcType.isString() ? (jdbcType.isLob() ? "to_nclob(?1)" : "to_nvarchar(?1)") : null;
    }

    public void appendWriteExpression(String writeExpression, @Nullable Size size, SqlAppender appender, Dialect dialect) {
        appender.append((CharSequence)"to_");
        appender.append((CharSequence)this.typeName);
        appender.append('(');
        appender.append((CharSequence)writeExpression);
        appender.append(')');
    }

    public boolean isWriteExpressionTyped(Dialect dialect) {
        return true;
    }

    public @Nullable String castFromPattern(JdbcMapping sourceMapping, @Nullable Size size) {
        return sourceMapping.getJdbcType().isStringLike() ? "to_" + this.typeName + "(?1)" : null;
    }

    public <X> ValueExtractor<X> getExtractor(final JavaType<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(this, javaTypeDescriptor, (JdbcType)this){
            final /* synthetic */ HANAVectorJdbcType this$0;
            {
                this.this$0 = this$0;
                super(javaType, jdbcType);
            }

            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap((Object)VectorHelper.parseFloatVector(rs.getString(paramIndex)), options);
            }

            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap((Object)VectorHelper.parseFloatVector(statement.getString(index)), options);
            }

            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap((Object)VectorHelper.parseFloatVector(statement.getString(name)), options);
            }
        };
    }

    public <X> ValueBinder<X> getBinder(JavaType<X> javaTypeDescriptor) {
        return new BasicBinder<X>(javaTypeDescriptor, (JdbcType)this){

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                st.setString(index, (String)this.getBindValue(value, options));
            }

            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                st.setString(name, (String)this.getBindValue(value, options));
            }

            public String getBindValue(X value, WrapperOptions options) {
                return Arrays.toString((float[])this.getJavaType().unwrap(value, float[].class, options));
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        if (!super.equals(that)) return false;
        if (!(that instanceof HANAVectorJdbcType)) return false;
        HANAVectorJdbcType vectorJdbcType = (HANAVectorJdbcType)((Object)that);
        if (this.sqlType != vectorJdbcType.sqlType) return false;
        return true;
    }

    public int hashCode() {
        return this.sqlType + 31 * super.hashCode();
    }
}

