/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector.internal;

import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.FunctionContributor;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.HANADialect;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionArgumentTypeResolver;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.vector.internal.VectorArgumentTypeResolver;
import org.hibernate.vector.internal.VectorArgumentValidator;
import org.hibernate.vector.internal.VectorFunctionFactory;

public class HANAVectorFunctionContributor
implements FunctionContributor {
    public void contributeFunctions(FunctionContributions functionContributions) {
        HANADialect hanaDialect;
        Dialect dialect = functionContributions.getDialect();
        if (dialect instanceof HANADialect && (hanaDialect = (HANADialect)dialect).isCloud()) {
            VectorFunctionFactory vectorFunctionFactory = new VectorFunctionFactory(functionContributions);
            vectorFunctionFactory.registerVectorDistanceFunction("cosine_similarity", "cosine_similarity(?1,?2)");
            vectorFunctionFactory.cosineDistance("(1-cosine_similarity(?1,?2))");
            vectorFunctionFactory.euclideanDistance("l2distance(?1,?2)");
            vectorFunctionFactory.euclideanSquaredDistance("power(l2distance(?1,?2),2)");
            TypeConfiguration typeConfiguration = functionContributions.getTypeConfiguration();
            vectorFunctionFactory.registerPatternVectorFunction("vector_dims", "cardinality(?1)", typeConfiguration.getBasicTypeForJavaType(Integer.class), 1);
            if (hanaDialect.getVersion().isSameOrAfter(4, 20252)) {
                vectorFunctionFactory.registerNamedVectorFunction("l2norm", typeConfiguration.getBasicTypeForJavaType(Double.class), 1);
                functionContributions.getFunctionRegistry().registerAlternateKey("vector_norm", "l2norm");
                functionContributions.getFunctionRegistry().registerAlternateKey("l2_norm", "l2norm");
                functionContributions.getFunctionRegistry().namedDescriptorBuilder("subvector").setArgumentsValidator(StandardArgumentsValidators.composite((ArgumentsValidator[])new ArgumentsValidator[]{StandardArgumentsValidators.exactly((int)3), VectorArgumentValidator.INSTANCE})).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.byArgument((FunctionArgumentTypeResolver[])new FunctionArgumentTypeResolver[]{VectorArgumentTypeResolver.INSTANCE, StandardFunctionArgumentTypeResolvers.invariant((TypeConfiguration)typeConfiguration, (FunctionParameterType)FunctionParameterType.INTEGER), StandardFunctionArgumentTypeResolvers.invariant((TypeConfiguration)typeConfiguration, (FunctionParameterType)FunctionParameterType.INTEGER)})).setReturnTypeResolver(StandardFunctionReturnTypeResolvers.useArgType((int)1)).register();
                functionContributions.getFunctionRegistry().namedDescriptorBuilder("l2normalize").setArgumentsValidator(VectorArgumentValidator.INSTANCE).setArgumentTypeResolver(VectorArgumentTypeResolver.INSTANCE).setReturnTypeResolver(StandardFunctionReturnTypeResolvers.useArgType((int)1)).register();
                functionContributions.getFunctionRegistry().registerAlternateKey("l2_normalize", "l2normalize");
            }
        }
    }

    public int ordinal() {
        return 200;
    }
}

