/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector.internal;

import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.spi.BasicJdbcLiteralFormatter;
import org.hibernate.vector.internal.AbstractDB2VectorJdbcType;

public class DB2JdbcLiteralFormatterVector<T>
extends BasicJdbcLiteralFormatter<T> {
    private final JdbcLiteralFormatter<Object> elementFormatter;
    private final AbstractDB2VectorJdbcType db2VectorJdbcType;

    public DB2JdbcLiteralFormatterVector(JavaType<T> javaType, JdbcLiteralFormatter<?> elementFormatter, AbstractDB2VectorJdbcType db2VectorJdbcType) {
        super(javaType);
        this.elementFormatter = elementFormatter;
        this.db2VectorJdbcType = db2VectorJdbcType;
    }

    public void appendJdbcLiteral(SqlAppender appender, T value, Dialect dialect, WrapperOptions wrapperOptions) {
        Object[] objects = this.unwrapArray(value, wrapperOptions);
        appender.append((CharSequence)"vector('");
        int separator = 91;
        for (Object o : objects) {
            appender.append((char)separator);
            this.elementFormatter.appendJdbcLiteral(appender, o, dialect, wrapperOptions);
            separator = 44;
        }
        appender.append((CharSequence)"]',");
        appender.append((CharSequence)this.db2VectorJdbcType.getVectorParameters(new Size().setArrayLength(Integer.valueOf(objects.length))));
        appender.append(')');
    }

    private Object[] unwrapArray(Object value, WrapperOptions wrapperOptions) {
        return (Object[])this.unwrap(value, Object[].class, wrapperOptions);
    }
}

