/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector;

import java.util.Arrays;
import java.util.List;
import org.hibernate.vector.AbstractSparseVector;

public class SparseFloatVector
extends AbstractSparseVector<Float> {
    private static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    private final int size;
    private int[] indices = EMPTY_INT_ARRAY;
    private float[] data = EMPTY_FLOAT_ARRAY;

    public SparseFloatVector(int size) {
        this.size = size;
    }

    public SparseFloatVector(List<Float> list) {
        if (list instanceof SparseFloatVector) {
            SparseFloatVector sparseVector = (SparseFloatVector)list;
            this.size = sparseVector.size;
            this.indices = (int[])sparseVector.indices.clone();
            this.data = (float[])sparseVector.data.clone();
        } else {
            int size = 0;
            int[] indices = new int[list.size()];
            float[] data = new float[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Float b = list.get(i);
                if (b == null || b.floatValue() == 0.0f) continue;
                indices[size] = i;
                data[size] = b.floatValue();
                ++size;
            }
            this.size = list.size();
            this.indices = Arrays.copyOf(indices, size);
            this.data = Arrays.copyOf(data, size);
        }
    }

    public SparseFloatVector(float[] denseVector) {
        int size = 0;
        int[] indices = new int[denseVector.length];
        float[] data = new float[denseVector.length];
        for (int i = 0; i < denseVector.length; ++i) {
            float b = denseVector[i];
            if (b == 0.0f) continue;
            indices[size] = i;
            data[size] = b;
            ++size;
        }
        this.size = denseVector.length;
        this.indices = Arrays.copyOf(indices, size);
        this.data = Arrays.copyOf(data, size);
    }

    public SparseFloatVector(int size, int[] indices, float[] data) {
        this(SparseFloatVector.validateData(data), SparseFloatVector.validateIndices(indices, data.length, size), size);
    }

    private SparseFloatVector(float[] data, int[] indices, int size) {
        this.size = size;
        this.indices = indices;
        this.data = data;
    }

    public SparseFloatVector(String string) {
        AbstractSparseVector.ParsedVector<Float> parsedVector = SparseFloatVector.parseSparseVector(string, (s, start, end) -> Float.valueOf(Float.parseFloat(s.substring(start, end))));
        this.size = parsedVector.size();
        this.indices = parsedVector.indices();
        this.data = SparseFloatVector.toFloatArray(parsedVector.elements());
    }

    private static float[] toFloatArray(List<Float> elements) {
        float[] result = new float[elements.size()];
        for (int i = 0; i < elements.size(); ++i) {
            result[i] = elements.get(i).floatValue();
        }
        return result;
    }

    private static float[] validateData(float[] data) {
        if (data == null) {
            throw new IllegalArgumentException("data cannot be null");
        }
        for (int i = 0; i < data.length; ++i) {
            if (data[i] != 0.0f) continue;
            throw new IllegalArgumentException("data[" + i + "] == 0");
        }
        return data;
    }

    public SparseFloatVector clone() {
        return new SparseFloatVector((float[])this.data.clone(), (int[])this.indices.clone(), this.size);
    }

    @Override
    public Float get(int index) {
        int foundIndex = Arrays.binarySearch(this.indices, index);
        return Float.valueOf(foundIndex < 0 ? 0.0f : this.data[foundIndex]);
    }

    @Override
    public Float set(int index, Float element) {
        int foundIndex = Arrays.binarySearch(this.indices, index);
        if (foundIndex < 0) {
            if (element != null && element.floatValue() != 0.0f) {
                int[] newIndices = new int[this.indices.length + 1];
                float[] newData = new float[this.data.length + 1];
                int insertionPoint = -foundIndex - 1;
                System.arraycopy(this.indices, 0, newIndices, 0, insertionPoint);
                System.arraycopy(this.data, 0, newData, 0, insertionPoint);
                newIndices[insertionPoint] = index;
                newData[insertionPoint] = element.floatValue();
                System.arraycopy(this.indices, insertionPoint, newIndices, insertionPoint + 1, this.indices.length - insertionPoint);
                System.arraycopy(this.data, insertionPoint, newData, insertionPoint + 1, this.data.length - insertionPoint);
                this.indices = newIndices;
                this.data = newData;
            }
            return null;
        }
        float oldValue = this.data[foundIndex];
        if (element != null && element.floatValue() != 0.0f) {
            this.data[foundIndex] = element.floatValue();
        } else {
            int[] newIndices = new int[this.indices.length - 1];
            float[] newData = new float[this.data.length - 1];
            System.arraycopy(this.indices, 0, newIndices, 0, foundIndex);
            System.arraycopy(this.data, 0, newData, 0, foundIndex);
            System.arraycopy(this.indices, foundIndex + 1, newIndices, foundIndex, this.indices.length - foundIndex - 1);
            System.arraycopy(this.data, foundIndex + 1, newData, foundIndex, this.data.length - foundIndex - 1);
            this.indices = newIndices;
            this.data = newData;
        }
        return Float.valueOf(oldValue);
    }

    public float[] toDenseVector() {
        float[] result = new float[this.size];
        for (int i = 0; i < this.indices.length; ++i) {
            result[this.indices[i]] = this.data[i];
        }
        return result;
    }

    @Override
    public int[] indices() {
        return this.indices;
    }

    public float[] floats() {
        return this.data;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public String toString() {
        return "[" + this.size + "," + Arrays.toString(this.indices) + "," + Arrays.toString(this.data) + "]";
    }
}

