/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector;

import java.util.Arrays;
import java.util.List;
import org.hibernate.vector.AbstractSparseVector;

public class SparseDoubleVector
extends AbstractSparseVector<Double> {
    private static final double[] EMPTY_FLOAT_ARRAY = new double[0];
    private final int size;
    private int[] indices = EMPTY_INT_ARRAY;
    private double[] data = EMPTY_FLOAT_ARRAY;

    public SparseDoubleVector(int size) {
        this.size = size;
    }

    public SparseDoubleVector(List<Double> list) {
        if (list instanceof SparseDoubleVector) {
            SparseDoubleVector sparseVector = (SparseDoubleVector)list;
            this.size = sparseVector.size;
            this.indices = (int[])sparseVector.indices.clone();
            this.data = (double[])sparseVector.data.clone();
        } else {
            int size = 0;
            int[] indices = new int[list.size()];
            double[] data = new double[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Double b = list.get(i);
                if (b == null || b == 0.0) continue;
                indices[size] = i;
                data[size] = b;
                ++size;
            }
            this.size = list.size();
            this.indices = Arrays.copyOf(indices, size);
            this.data = Arrays.copyOf(data, size);
        }
    }

    public SparseDoubleVector(double[] denseVector) {
        int size = 0;
        int[] indices = new int[denseVector.length];
        double[] data = new double[denseVector.length];
        for (int i = 0; i < denseVector.length; ++i) {
            double b = denseVector[i];
            if (b == 0.0) continue;
            indices[size] = i;
            data[size] = b;
            ++size;
        }
        this.size = denseVector.length;
        this.indices = Arrays.copyOf(indices, size);
        this.data = Arrays.copyOf(data, size);
    }

    public SparseDoubleVector(int size, int[] indices, double[] data) {
        this(SparseDoubleVector.validateData(data), SparseDoubleVector.validateIndices(indices, data.length, size), size);
    }

    private SparseDoubleVector(double[] data, int[] indices, int size) {
        this.size = size;
        this.indices = indices;
        this.data = data;
    }

    public SparseDoubleVector(String string) {
        AbstractSparseVector.ParsedVector<Double> parsedVector = SparseDoubleVector.parseSparseVector(string, (s, start, end) -> Double.parseDouble(s.substring(start, end)));
        this.size = parsedVector.size();
        this.indices = parsedVector.indices();
        this.data = SparseDoubleVector.toDoubleArray(parsedVector.elements());
    }

    private static double[] toDoubleArray(List<Double> elements) {
        double[] result = new double[elements.size()];
        for (int i = 0; i < elements.size(); ++i) {
            result[i] = elements.get(i);
        }
        return result;
    }

    private static double[] validateData(double[] data) {
        if (data == null) {
            throw new IllegalArgumentException("data cannot be null");
        }
        for (int i = 0; i < data.length; ++i) {
            if (data[i] != 0.0) continue;
            throw new IllegalArgumentException("data[" + i + "] == 0");
        }
        return data;
    }

    public SparseDoubleVector clone() {
        return new SparseDoubleVector((double[])this.data.clone(), (int[])this.indices.clone(), this.size);
    }

    @Override
    public Double get(int index) {
        int foundIndex = Arrays.binarySearch(this.indices, index);
        return foundIndex < 0 ? 0.0 : this.data[foundIndex];
    }

    @Override
    public Double set(int index, Double element) {
        int foundIndex = Arrays.binarySearch(this.indices, index);
        if (foundIndex < 0) {
            if (element != null && element != 0.0) {
                int[] newIndices = new int[this.indices.length + 1];
                double[] newData = new double[this.data.length + 1];
                int insertionPoint = -foundIndex - 1;
                System.arraycopy(this.indices, 0, newIndices, 0, insertionPoint);
                System.arraycopy(this.data, 0, newData, 0, insertionPoint);
                newIndices[insertionPoint] = index;
                newData[insertionPoint] = element;
                System.arraycopy(this.indices, insertionPoint, newIndices, insertionPoint + 1, this.indices.length - insertionPoint);
                System.arraycopy(this.data, insertionPoint, newData, insertionPoint + 1, this.data.length - insertionPoint);
                this.indices = newIndices;
                this.data = newData;
            }
            return null;
        }
        double oldValue = this.data[foundIndex];
        if (element != null && element != 0.0) {
            this.data[foundIndex] = element;
        } else {
            int[] newIndices = new int[this.indices.length - 1];
            double[] newData = new double[this.data.length - 1];
            System.arraycopy(this.indices, 0, newIndices, 0, foundIndex);
            System.arraycopy(this.data, 0, newData, 0, foundIndex);
            System.arraycopy(this.indices, foundIndex + 1, newIndices, foundIndex, this.indices.length - foundIndex - 1);
            System.arraycopy(this.data, foundIndex + 1, newData, foundIndex, this.data.length - foundIndex - 1);
            this.indices = newIndices;
            this.data = newData;
        }
        return oldValue;
    }

    public double[] toDenseVector() {
        double[] result = new double[this.size];
        for (int i = 0; i < this.indices.length; ++i) {
            result[this.indices[i]] = this.data[i];
        }
        return result;
    }

    @Override
    public int[] indices() {
        return this.indices;
    }

    public double[] doubles() {
        return this.data;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public String toString() {
        return "[" + this.size + "," + Arrays.toString(this.indices) + "," + Arrays.toString(this.data) + "]";
    }
}

