/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector;

import java.util.Arrays;
import java.util.List;
import org.hibernate.vector.AbstractSparseVector;

public class SparseByteVector
extends AbstractSparseVector<Byte> {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final int size;
    private int[] indices = EMPTY_INT_ARRAY;
    private byte[] data = EMPTY_BYTE_ARRAY;

    public SparseByteVector(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("size must be greater than zero");
        }
        this.size = size;
    }

    public SparseByteVector(List<Byte> list) {
        if (list instanceof SparseByteVector) {
            SparseByteVector sparseVector = (SparseByteVector)list;
            this.size = sparseVector.size;
            this.indices = (int[])sparseVector.indices.clone();
            this.data = (byte[])sparseVector.data.clone();
        } else {
            if (list == null) {
                throw new IllegalArgumentException("list cannot be null");
            }
            if (list.isEmpty()) {
                throw new IllegalArgumentException("list cannot be empty");
            }
            int size = 0;
            int[] indices = new int[list.size()];
            byte[] data = new byte[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Byte b = list.get(i);
                if (b == null || b == 0) continue;
                indices[size] = i;
                data[size] = b;
                ++size;
            }
            this.size = list.size();
            this.indices = Arrays.copyOf(indices, size);
            this.data = Arrays.copyOf(data, size);
        }
    }

    public SparseByteVector(byte[] denseVector) {
        if (denseVector == null) {
            throw new IllegalArgumentException("denseVector cannot be null");
        }
        if (denseVector.length == 0) {
            throw new IllegalArgumentException("denseVector cannot be empty");
        }
        int size = 0;
        int[] indices = new int[denseVector.length];
        byte[] data = new byte[denseVector.length];
        for (int i = 0; i < denseVector.length; ++i) {
            byte b = denseVector[i];
            if (b == 0) continue;
            indices[size] = i;
            data[size] = b;
            ++size;
        }
        this.size = denseVector.length;
        this.indices = Arrays.copyOf(indices, size);
        this.data = Arrays.copyOf(data, size);
    }

    public SparseByteVector(int size, int[] indices, byte[] data) {
        this(SparseByteVector.validateData(data, size), SparseByteVector.validateIndices(indices, data.length, size), size);
    }

    private SparseByteVector(byte[] data, int[] indices, int size) {
        this.size = size;
        this.indices = indices;
        this.data = data;
    }

    public SparseByteVector(String string) {
        AbstractSparseVector.ParsedVector<Byte> parsedVector = SparseByteVector.parseSparseVector(string, (s, start, end) -> Byte.parseByte(s.substring(start, end)));
        this.size = parsedVector.size();
        this.indices = parsedVector.indices();
        this.data = SparseByteVector.toByteArray(parsedVector.elements());
    }

    private static byte[] toByteArray(List<Byte> elements) {
        byte[] result = new byte[elements.size()];
        for (int i = 0; i < elements.size(); ++i) {
            result[i] = elements.get(i);
        }
        return result;
    }

    private static byte[] validateData(byte[] data, int size) {
        if (size == 0) {
            throw new IllegalArgumentException("size cannot be 0");
        }
        if (data == null) {
            throw new IllegalArgumentException("data cannot be null");
        }
        if (size < data.length) {
            throw new IllegalArgumentException("size cannot be smaller than data size");
        }
        for (int i = 0; i < data.length; ++i) {
            if (data[i] != 0) continue;
            throw new IllegalArgumentException("data[" + i + "] == 0");
        }
        return data;
    }

    public SparseByteVector clone() {
        return new SparseByteVector((byte[])this.data.clone(), (int[])this.indices.clone(), this.size);
    }

    @Override
    public Byte get(int index) {
        int foundIndex = Arrays.binarySearch(this.indices, index);
        return foundIndex < 0 ? (byte)0 : this.data[foundIndex];
    }

    @Override
    public Byte set(int index, Byte element) {
        int foundIndex = Arrays.binarySearch(this.indices, index);
        if (foundIndex < 0) {
            if (element != null && element != 0) {
                int[] newIndices = new int[this.indices.length + 1];
                byte[] newData = new byte[this.data.length + 1];
                int insertionPoint = -foundIndex - 1;
                System.arraycopy(this.indices, 0, newIndices, 0, insertionPoint);
                System.arraycopy(this.data, 0, newData, 0, insertionPoint);
                newIndices[insertionPoint] = index;
                newData[insertionPoint] = element;
                System.arraycopy(this.indices, insertionPoint, newIndices, insertionPoint + 1, this.indices.length - insertionPoint);
                System.arraycopy(this.data, insertionPoint, newData, insertionPoint + 1, this.data.length - insertionPoint);
                this.indices = newIndices;
                this.data = newData;
            }
            return null;
        }
        byte oldValue = this.data[foundIndex];
        if (element != null && element != 0) {
            this.data[foundIndex] = element;
        } else {
            int[] newIndices = new int[this.indices.length - 1];
            byte[] newData = new byte[this.data.length - 1];
            System.arraycopy(this.indices, 0, newIndices, 0, foundIndex);
            System.arraycopy(this.data, 0, newData, 0, foundIndex);
            System.arraycopy(this.indices, foundIndex + 1, newIndices, foundIndex, this.indices.length - foundIndex - 1);
            System.arraycopy(this.data, foundIndex + 1, newData, foundIndex, this.data.length - foundIndex - 1);
            this.indices = newIndices;
            this.data = newData;
        }
        return oldValue;
    }

    public byte[] toDenseVector() {
        byte[] result = new byte[this.size];
        for (int i = 0; i < this.indices.length; ++i) {
            result[this.indices[i]] = this.data[i];
        }
        return result;
    }

    @Override
    public int[] indices() {
        return this.indices;
    }

    public byte[] bytes() {
        return this.data;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public String toString() {
        return "[" + this.size + "," + Arrays.toString(this.indices) + "," + Arrays.toString(this.data) + "]";
    }
}

