/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector;

import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.FunctionContributor;
import org.hibernate.dialect.CockroachDialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.vector.VectorFunctionFactory;

public class PGVectorFunctionContributor
implements FunctionContributor {
    public void contributeFunctions(FunctionContributions functionContributions) {
        Dialect dialect = functionContributions.getDialect();
        if (dialect instanceof PostgreSQLDialect || dialect instanceof CockroachDialect) {
            VectorFunctionFactory vectorFunctionFactory = new VectorFunctionFactory(functionContributions);
            vectorFunctionFactory.cosineDistance("?1<=>?2");
            vectorFunctionFactory.euclideanDistance("?1<->?2");
            vectorFunctionFactory.l1Distance("l1_distance(?1,?2)");
            vectorFunctionFactory.innerProduct("(?1<#>?2)*-1");
            vectorFunctionFactory.negativeInnerProduct("?1<#>?2");
            vectorFunctionFactory.vectorDimensions();
            vectorFunctionFactory.vectorNorm();
        }
    }

    public int ordinal() {
        return 200;
    }
}

