/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector;

import java.util.Arrays;
import java.util.BitSet;
import org.hibernate.dialect.Dialect;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.vector.AbstractOracleVectorJdbcType;

public class OracleDoubleVectorJdbcType
extends AbstractOracleVectorJdbcType {
    private static final double[] EMPTY = new double[0];

    public OracleDoubleVectorJdbcType(JdbcType elementJdbcType, boolean isVectorSupported) {
        super(elementJdbcType, isVectorSupported);
    }

    @Override
    public void appendWriteExpression(String writeExpression, SqlAppender appender, Dialect dialect) {
        appender.append((CharSequence)"to_vector(");
        appender.append((CharSequence)writeExpression);
        appender.append((CharSequence)", *, FLOAT64)");
    }

    public String getFriendlyName() {
        return "VECTOR_FLOAT64";
    }

    @Override
    public int getDefaultSqlTypeCode() {
        return 10003;
    }

    protected double[] getVectorArray(String string) {
        int commaIndex;
        if (string == null) {
            return null;
        }
        if (string.length() == 2) {
            return EMPTY;
        }
        BitSet commaPositions = new BitSet();
        int size = 1;
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != ',') continue;
            commaPositions.set(i);
            ++size;
        }
        double[] result = new double[size];
        int doubleStartIndex = 1;
        int index = 0;
        while ((commaIndex = commaPositions.nextSetBit(doubleStartIndex)) != -1) {
            result[index++] = Double.parseDouble(string.substring(doubleStartIndex, commaIndex));
            doubleStartIndex = commaIndex + 1;
        }
        result[index] = Double.parseDouble(string.substring(doubleStartIndex, string.length() - 1));
        return result;
    }

    @Override
    protected <T> String getStringVector(T vector, JavaType<T> javaTypeDescriptor, WrapperOptions options) {
        return Arrays.toString((double[])javaTypeDescriptor.unwrap(vector, double[].class, options));
    }

    @Override
    protected Class<?> getNativeJavaType() {
        return double[].class;
    }

    @Override
    protected int getNativeTypeCode() {
        return -108;
    }
}

