/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector;

import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.FunctionContributor;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.vector.VectorArgumentTypeResolver;
import org.hibernate.vector.VectorArgumentValidator;

public class OracleVectorFunctionContributor
implements FunctionContributor {
    public void contributeFunctions(FunctionContributions functionContributions) {
        SqmFunctionRegistry functionRegistry = functionContributions.getFunctionRegistry();
        TypeConfiguration typeConfiguration = functionContributions.getTypeConfiguration();
        BasicTypeRegistry basicTypeRegistry = typeConfiguration.getBasicTypeRegistry();
        Dialect dialect = functionContributions.getDialect();
        if (dialect instanceof OracleDialect) {
            BasicType doubleType = basicTypeRegistry.resolve(StandardBasicTypes.DOUBLE);
            BasicType integerType = basicTypeRegistry.resolve(StandardBasicTypes.INTEGER);
            functionRegistry.patternDescriptorBuilder("cosine_distance", "vector_distance(?1, ?2, COSINE)").setArgumentsValidator(StandardArgumentsValidators.composite((ArgumentsValidator[])new ArgumentsValidator[]{StandardArgumentsValidators.exactly((int)2), VectorArgumentValidator.INSTANCE})).setArgumentTypeResolver(VectorArgumentTypeResolver.INSTANCE).setReturnTypeResolver(StandardFunctionReturnTypeResolvers.invariant((BasicType)doubleType)).register();
            functionRegistry.patternDescriptorBuilder("euclidean_distance", "vector_distance(?1, ?2, EUCLIDEAN)").setArgumentsValidator(StandardArgumentsValidators.composite((ArgumentsValidator[])new ArgumentsValidator[]{StandardArgumentsValidators.exactly((int)2), VectorArgumentValidator.INSTANCE})).setArgumentTypeResolver(VectorArgumentTypeResolver.INSTANCE).setReturnTypeResolver(StandardFunctionReturnTypeResolvers.invariant((BasicType)doubleType)).register();
            functionRegistry.registerAlternateKey("l2_distance", "euclidean_distance");
            functionRegistry.patternDescriptorBuilder("l1_distance", "vector_distance(?1, ?2, MANHATTAN)").setArgumentsValidator(StandardArgumentsValidators.composite((ArgumentsValidator[])new ArgumentsValidator[]{StandardArgumentsValidators.exactly((int)2), VectorArgumentValidator.INSTANCE})).setArgumentTypeResolver(VectorArgumentTypeResolver.INSTANCE).setReturnTypeResolver(StandardFunctionReturnTypeResolvers.invariant((BasicType)doubleType)).register();
            functionRegistry.registerAlternateKey("taxicab_distance", "l1_distance");
            functionRegistry.patternDescriptorBuilder("negative_inner_product", "vector_distance(?1, ?2, DOT)").setArgumentsValidator(StandardArgumentsValidators.composite((ArgumentsValidator[])new ArgumentsValidator[]{StandardArgumentsValidators.exactly((int)2), VectorArgumentValidator.INSTANCE})).setArgumentTypeResolver(VectorArgumentTypeResolver.INSTANCE).setReturnTypeResolver(StandardFunctionReturnTypeResolvers.invariant((BasicType)doubleType)).register();
            functionRegistry.patternDescriptorBuilder("inner_product", "vector_distance(?1, ?2, DOT)*-1").setArgumentsValidator(StandardArgumentsValidators.composite((ArgumentsValidator[])new ArgumentsValidator[]{StandardArgumentsValidators.exactly((int)2), VectorArgumentValidator.INSTANCE})).setArgumentTypeResolver(VectorArgumentTypeResolver.INSTANCE).setReturnTypeResolver(StandardFunctionReturnTypeResolvers.invariant((BasicType)doubleType)).register();
            functionRegistry.patternDescriptorBuilder("hamming_distance", "vector_distance(?1, ?2, HAMMING)").setArgumentsValidator(StandardArgumentsValidators.composite((ArgumentsValidator[])new ArgumentsValidator[]{StandardArgumentsValidators.exactly((int)2), VectorArgumentValidator.INSTANCE})).setArgumentTypeResolver(VectorArgumentTypeResolver.INSTANCE).setReturnTypeResolver(StandardFunctionReturnTypeResolvers.invariant((BasicType)doubleType)).register();
            functionRegistry.namedDescriptorBuilder("vector_dims").setArgumentsValidator(StandardArgumentsValidators.composite((ArgumentsValidator[])new ArgumentsValidator[]{StandardArgumentsValidators.exactly((int)1), VectorArgumentValidator.INSTANCE})).setArgumentTypeResolver(VectorArgumentTypeResolver.INSTANCE).setReturnTypeResolver(StandardFunctionReturnTypeResolvers.invariant((BasicType)integerType)).register();
            functionRegistry.namedDescriptorBuilder("vector_norm").setArgumentsValidator(StandardArgumentsValidators.composite((ArgumentsValidator[])new ArgumentsValidator[]{StandardArgumentsValidators.exactly((int)1), VectorArgumentValidator.INSTANCE})).setArgumentTypeResolver(VectorArgumentTypeResolver.INSTANCE).setReturnTypeResolver(StandardFunctionReturnTypeResolvers.invariant((BasicType)doubleType)).register();
        }
    }

    public int ordinal() {
        return 200;
    }
}

