/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector;

import java.util.List;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionArgumentException;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.BasicType;
import org.hibernate.type.spi.TypeConfiguration;

public class VectorArgumentValidator
implements ArgumentsValidator {
    public static final ArgumentsValidator INSTANCE = new VectorArgumentValidator();

    public void validate(List<? extends SqmTypedNode<?>> arguments, String functionName, TypeConfiguration typeConfiguration) {
        for (int i = 0; i < arguments.size(); ++i) {
            DomainType type;
            SqmExpressible expressible = arguments.get(i).getExpressible();
            if (expressible == null || (type = expressible.getSqmType()) == null || VectorArgumentValidator.isVectorType(type)) continue;
            throw new FunctionArgumentException(String.format("Parameter %d of function '%s()' requires a vector type, but argument is of type '%s'", i, functionName, type.getTypeName()));
        }
    }

    private static boolean isVectorType(SqmExpressible<?> vectorType) {
        if (!(vectorType instanceof BasicPluralType)) {
            return false;
        }
        switch (((BasicType)vectorType).getJdbcType().getDefaultSqlTypeCode()) {
            case 10000: 
            case 10001: 
            case 10002: 
            case 10003: {
                return true;
            }
        }
        return false;
    }
}

