/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.oracleucp.internal;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.UniversalConnectionPoolManager;
import oracle.ucp.admin.UniversalConnectionPoolManagerImpl;
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.jdbc.PoolDataSourceFactory;
import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.connections.internal.ConnectionProviderInitiator;
import org.hibernate.engine.jdbc.connections.internal.DatabaseConnectionInfoImpl;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.DatabaseConnectionInfo;
import org.hibernate.internal.log.ConnectionInfoLogger;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.UnknownUnwrapTypeException;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.Stoppable;

public class UCPConnectionProvider
implements ConnectionProvider,
Configurable,
Stoppable {
    private static final long serialVersionUID = 1L;
    private PoolDataSource ucpDS = null;
    private UniversalConnectionPoolManager poolManager = null;
    private static final String UCP_CONFIG_PREFIX = "hibernate.oracleucp";
    private static final String CONFIG_PREFIX = "hibernate.oracleucp.";
    private boolean autoCommit;
    private Integer isolation;
    private DatabaseConnectionInfo dbInfo;

    public void configure(Map props) throws HibernateException {
        try {
            ConnectionInfoLogger.INSTANCE.configureConnectionPool("Ucp");
            this.isolation = ConnectionProviderInitiator.extractIsolation((Map)props);
            this.autoCommit = ConfigurationHelper.getBoolean((String)"hibernate.connection.autocommit", (Map)props);
            UniversalConnectionPoolManager poolManager = UniversalConnectionPoolManagerImpl.getUniversalConnectionPoolManager();
            this.ucpDS = PoolDataSourceFactory.getPoolDataSource();
            Properties ucpProps = this.getConfiguration(props);
            this.configureDataSource(this.ucpDS, ucpProps);
            this.dbInfo = new DatabaseConnectionInfoImpl().setDBUrl(this.ucpDS.getURL()).setDBDriverName(this.ucpDS.getConnectionFactoryClassName()).setDBAutoCommitMode(Boolean.toString(this.autoCommit)).setDBIsolationLevel(this.isolation != null ? ConnectionProviderInitiator.toIsolationConnectionConstantName((Integer)this.isolation) : null).setDBMinPoolSize(String.valueOf(this.ucpDS.getMinPoolSize())).setDBMaxPoolSize(String.valueOf(this.ucpDS.getMaxPoolSize()));
        }
        catch (Exception e) {
            ConnectionInfoLogger.INSTANCE.unableToInstantiateConnectionPool(e);
            throw new HibernateException((Throwable)e);
        }
    }

    private void configureDataSource(PoolDataSource ucpDS, Properties ucpProps) {
        List<Method> methods = Arrays.asList(PoolDataSource.class.getDeclaredMethods());
        for (String propName : ucpProps.stringPropertyNames()) {
            String value = ucpProps.getProperty(propName);
            String methodName = "set" + propName.substring(0, 1).toUpperCase(Locale.ENGLISH) + propName.substring(1);
            Method writeMethod = methods.stream().filter(m -> m.getName().equals(methodName) && m.getParameterCount() == 1).findFirst().orElse(null);
            if (writeMethod == null) {
                throw new RuntimeException("Property " + propName + " does not exist on target " + PoolDataSource.class);
            }
            try {
                Class<?> paramClass = writeMethod.getParameterTypes()[0];
                if (paramClass == Integer.TYPE) {
                    writeMethod.invoke((Object)ucpDS, Integer.parseInt(value.toString()));
                    continue;
                }
                if (paramClass == Long.TYPE) {
                    writeMethod.invoke((Object)ucpDS, Long.parseLong(value.toString()));
                    continue;
                }
                if (paramClass == Boolean.TYPE || paramClass == Boolean.class) {
                    writeMethod.invoke((Object)ucpDS, Boolean.parseBoolean(value.toString()));
                    continue;
                }
                if (paramClass == String.class) {
                    writeMethod.invoke((Object)ucpDS, value.toString());
                    continue;
                }
                if (propName.equals("connectionProperties") || propName.equals("connectionFactoryProperties")) {
                    String[] propStrs;
                    if (value == null) continue;
                    Properties connProps = new Properties();
                    for (String onePropStr : propStrs = value.substring(1, value.length() - 1).split(", ")) {
                        String[] nvPair = onePropStr.split("=");
                        connProps.setProperty(nvPair[0], nvPair[1]);
                    }
                    writeMethod.invoke((Object)ucpDS, connProps);
                    continue;
                }
                writeMethod.invoke((Object)ucpDS, value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Properties getConfiguration(Map<?, ?> props) {
        Properties ucpProps = new Properties();
        UCPConnectionProvider.copyProperty("hibernate.connection.url", props, "URL", ucpProps);
        UCPConnectionProvider.copyProperty("hibernate.connection.username", props, "user", ucpProps);
        UCPConnectionProvider.copyProperty("hibernate.connection.password", props, "password", ucpProps);
        for (Object keyo : props.keySet()) {
            String key;
            if (!(keyo instanceof String) || !(key = (String)keyo).startsWith(CONFIG_PREFIX)) continue;
            ucpProps.setProperty(key.substring(CONFIG_PREFIX.length()), (String)props.get(key));
        }
        return ucpProps;
    }

    private static void copyProperty(String srcKey, Map src, String dstKey, Properties dst) {
        if (src.containsKey(srcKey)) {
            dst.setProperty(dstKey, (String)src.get(srcKey));
        }
    }

    public Connection getConnection() throws SQLException {
        Connection conn = null;
        if (this.ucpDS != null) {
            conn = this.ucpDS.getConnection();
            if (this.isolation != null && this.isolation.intValue() != conn.getTransactionIsolation()) {
                conn.setTransactionIsolation(this.isolation);
            }
            if (conn.getAutoCommit() != this.autoCommit) {
                conn.setAutoCommit(this.autoCommit);
            }
        }
        return conn;
    }

    public void closeConnection(Connection conn) throws SQLException {
        conn.close();
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }

    public DatabaseConnectionInfo getDatabaseConnectionInfo() {
        return this.dbInfo;
    }

    public boolean isUnwrappableAs(Class unwrapType) {
        return ConnectionProvider.class.equals((Object)unwrapType) || UCPConnectionProvider.class.isAssignableFrom(unwrapType) || DataSource.class.isAssignableFrom(unwrapType);
    }

    public <T> T unwrap(Class<T> unwrapType) {
        if (ConnectionProvider.class.equals(unwrapType) || UCPConnectionProvider.class.isAssignableFrom(unwrapType)) {
            return (T)this;
        }
        if (DataSource.class.isAssignableFrom(unwrapType)) {
            return (T)this.ucpDS;
        }
        throw new UnknownUnwrapTypeException(unwrapType);
    }

    public void stop() {
        if (this.ucpDS != null && this.ucpDS.getConnectionPoolName() != null) {
            ConnectionInfoLogger.INSTANCE.cleaningUpConnectionPool("hibernate.oracleucp [" + this.ucpDS.getConnectionPoolName() + "]");
            try {
                UniversalConnectionPoolManager poolManager = UniversalConnectionPoolManagerImpl.getUniversalConnectionPoolManager();
                poolManager.destroyConnectionPool(this.ucpDS.getConnectionPoolName());
            }
            catch (UniversalConnectionPoolException e) {
                ConnectionInfoLogger.INSTANCE.unableToDestroyConnectionPool((Exception)((Object)e));
            }
        }
    }
}

