/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor;

import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor8;
import org.hibernate.processor.Context;
import org.hibernate.processor.util.Constants;
import org.hibernate.processor.util.NullnessUtil;
import org.hibernate.processor.util.StringUtil;
import org.hibernate.processor.util.TypeUtils;

class ContainsAttributeTypeVisitor
extends SimpleTypeVisitor8<Boolean, Element> {
    private final Context context;
    private final TypeElement type;

    ContainsAttributeTypeVisitor(TypeElement elem, Context context) {
        this.context = context;
        this.type = elem;
    }

    @Override
    public Boolean visitDeclared(DeclaredType declaredType, Element element) {
        TypeElement returnedElement = (TypeElement)this.context.getTypeUtils().asElement(declaredType);
        String returnTypeName = NullnessUtil.castNonNull(returnedElement).getQualifiedName().toString();
        String collection = Constants.COLLECTIONS.get(returnTypeName);
        if (collection != null) {
            TypeMirror collectionElementType = TypeUtils.getCollectionElementType(declaredType, returnTypeName, null, this.context);
            Element collectionElement = this.context.getTypeUtils().asElement(collectionElementType);
            if (ElementKind.TYPE_PARAMETER == NullnessUtil.castNonNull(collectionElement).getKind()) {
                return false;
            }
            returnedElement = (TypeElement)collectionElement;
        }
        return this.type.getQualifiedName().contentEquals(returnedElement.getQualifiedName());
    }

    @Override
    public Boolean visitExecutable(ExecutableType executable, Element element) {
        return element.getKind() == ElementKind.METHOD && StringUtil.isProperty(element.getSimpleName().toString(), TypeUtils.toTypeString(executable.getReturnType())) && executable.getReturnType().accept(this, element) != false;
    }
}

