/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import java.util.Collections;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.processor.annotation.AbstractFinderMethod;
import org.hibernate.processor.annotation.AnnotationMetaEntity;

public class NaturalIdFinderMethod
extends AbstractFinderMethod {
    public static final String IDENTIFIER = "org.hibernate.reactive.common.Identifier";
    private final List<Boolean> paramNullability;

    public NaturalIdFinderMethod(AnnotationMetaEntity annotationMetaEntity, ExecutableElement method, String methodName, String entity, @Nullable String containerType, List<String> paramNames, List<String> paramTypes, List<Boolean> paramNullability, boolean belongsToDao, String sessionType, String sessionName, List<String> fetchProfiles, boolean addNonnullAnnotation, boolean dataRepository, String fullReturnType) {
        super(annotationMetaEntity, method, methodName, entity, containerType, belongsToDao, sessionType, sessionName, fetchProfiles, paramNames, paramTypes, Collections.emptyList(), addNonnullAnnotation, dataRepository, fullReturnType, true);
        this.paramNullability = paramNullability;
    }

    @Override
    boolean isNullable(int index) {
        return this.paramNullability.get(index);
    }

    @Override
    boolean singleResult() {
        return true;
    }

    @Override
    public String getAttributeDeclarationString() {
        StringBuilder declaration = new StringBuilder();
        this.comment(declaration);
        this.modifiers(declaration);
        this.preamble(declaration, this.paramTypes);
        this.tryReturn(declaration);
        this.unwrapSession(declaration);
        if (this.isReactive()) {
            this.findReactively(declaration);
        } else {
            this.findBlockingly(declaration);
        }
        this.convertExceptions(declaration);
        NaturalIdFinderMethod.closingBrace(declaration);
        return declaration.toString();
    }

    private void findBlockingly(StringBuilder declaration) {
        declaration.append(".byNaturalId(").append(this.annotationMetaEntity.importType(this.entity)).append(".class)\n");
        this.enableFetchProfile(declaration, true);
        for (int i = 0; i < this.paramNames.size(); ++i) {
            if (NaturalIdFinderMethod.isSessionParameter((String)this.paramTypes.get(i))) continue;
            String paramName = (String)this.paramNames.get(i);
            declaration.append("\t\t\t.using(").append(this.annotationMetaEntity.importType(this.entity + "_")).append('.').append(paramName).append(", ").append(paramName).append(")\n");
        }
        if (this.containerType == null) {
            declaration.append("\t\t\t.load()");
        } else {
            declaration.append("\t\t\t.loadOptional()");
        }
    }

    private void findReactively(StringBuilder declaration) {
        boolean composite = this.isComposite();
        declaration.append(".find(");
        if (composite) {
            declaration.append("\n\t\t\t");
        }
        declaration.append(this.annotationMetaEntity.importType(this.entity)).append(".class, ");
        if (composite) {
            declaration.append("\n\t\t\t").append(this.annotationMetaEntity.importType(IDENTIFIER)).append(".composite(");
        }
        boolean first = true;
        for (int i = 0; i < this.paramNames.size(); ++i) {
            if (NaturalIdFinderMethod.isSessionParameter((String)this.paramTypes.get(i))) continue;
            if (first) {
                first = false;
            } else {
                declaration.append(", ");
            }
            if (composite) {
                declaration.append("\n\t\t\t\t");
            }
            String paramName = (String)this.paramNames.get(i);
            declaration.append(this.annotationMetaEntity.importType(IDENTIFIER)).append(".id(").append(this.annotationMetaEntity.importType(this.entity + "_")).append('.').append(paramName).append(", ").append(paramName).append(")");
        }
        if (composite) {
            declaration.append("\n\t\t\t)\n\t");
        }
        declaration.append(')');
    }

    private boolean isComposite() {
        return this.paramTypes.stream().filter(type -> !NaturalIdFinderMethod.isSessionParameter(type)).count() > 1L;
    }
}

