/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.processor.annotation.NameMetaAttribute;
import org.hibernate.processor.model.Metamodel;
import org.hibernate.processor.util.StringUtil;

class TypedMetaAttribute
extends NameMetaAttribute {
    private final String prefix;
    private final String resultType;
    private final String referenceType;
    private final @Nullable String query;

    public TypedMetaAttribute(Metamodel annotationMetaEntity, String name, String prefix, String resultType, String referenceType, @Nullable String query) {
        super(annotationMetaEntity, name, prefix);
        this.prefix = prefix;
        this.resultType = resultType;
        this.referenceType = referenceType;
        this.query = query;
    }

    @Override
    public boolean hasTypedAttribute() {
        return true;
    }

    private boolean isQuery() {
        return "QUERY_".equals(this.prefix);
    }

    @Override
    public String getAttributeNameDeclarationString() {
        StringBuilder declaration = new StringBuilder();
        declaration.append("\n/**\n * @see ").append("#");
        this.appendFieldName(declaration, this.isQuery());
        return declaration.append("\n **/\n").append(super.getAttributeNameDeclarationString()).toString();
    }

    @Override
    public String getAttributeDeclarationString() {
        boolean isQuery = this.isQuery();
        Metamodel entity = this.getHostingEntity();
        StringBuilder declaration = new StringBuilder();
        declaration.append("\n/**").append("\n * The ").append(isQuery ? "query" : "entity graph").append(" named {@value ").append(this.prefix).append(this.fieldName()).append("}\n");
        if (this.query != null) {
            declaration.append(" * <pre>");
            this.query.lines().forEach(line -> declaration.append("\n * ").append((String)line));
            declaration.append("\n * </pre>\n");
        }
        declaration.append(" *\n * @see ").append(entity.getQualifiedName()).append("\n **/\n").append("public static volatile ").append(entity.importType(this.referenceType)).append('<').append(entity.importType(this.resultType)).append('>').append(' ');
        this.appendFieldName(declaration, isQuery);
        declaration.append(';');
        return declaration.toString();
    }

    private void appendFieldName(StringBuilder declaration, boolean isQuery) {
        declaration.append('_').append(StringUtil.nameToMethodName(this.getPropertyName()));
        if (isQuery) {
            declaration.append('_');
        }
    }
}

