/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import java.util.BitSet;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.dfa.DFA;
import org.hibernate.processor.Context;
import org.hibernate.processor.validation.Validation;
import org.hibernate.query.hql.internal.StandardHqlTranslator;

class ErrorHandler
implements Validation.Handler {
    private final Element element;
    private final AnnotationMirror mirror;
    private final AnnotationValue value;
    private final String queryString;
    private final Context context;
    private int errorCount;

    public ErrorHandler(Context context, Element element, AnnotationMirror mirror, AnnotationValue value, String hql) {
        this.element = element;
        this.mirror = mirror;
        this.value = value;
        this.queryString = hql;
        this.context = context;
    }

    @Override
    public int getErrorCount() {
        return this.errorCount;
    }

    @Override
    public void error(int start, int end, String message) {
        ++this.errorCount;
        this.context.message(this.element, this.mirror, this.value, message, Diagnostic.Kind.ERROR);
    }

    @Override
    public void warn(int start, int end, String message) {
        this.context.message(this.element, this.mirror, this.value, message, Diagnostic.Kind.WARNING);
    }

    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String message, RecognitionException e) {
        ++this.errorCount;
        String prettyMessage = "illegal HQL syntax - " + StandardHqlTranslator.prettifyAntlrError((Object)offendingSymbol, (int)line, (int)charPositionInLine, (String)message, (RecognitionException)e, (String)this.queryString, (boolean)false);
        this.context.message(this.element, this.mirror, this.value, prettyMessage, Diagnostic.Kind.ERROR);
    }

    public void reportAmbiguity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, boolean exact, BitSet ambigAlts, ATNConfigSet configs) {
    }

    public void reportAttemptingFullContext(Parser recognizer, DFA dfa, int startIndex, int stopIndex, BitSet conflictingAlts, ATNConfigSet configs) {
    }

    public void reportContextSensitivity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, int prediction, ATNConfigSet configs) {
    }
}

